/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.FileValidator;
import hath.base.HVFile;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import hath.base.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class CacheHandler {
    private static final int MEMORY_TABLE_ELEMENTS = 0x100000;
    private Hashtable<String, Long> staticRangeOldest = null;
    private HentaiAtHomeClient client = null;
    private File cachedir = null;
    private short[] lruCacheTable = null;
    private int cacheCount = 0;
    private int lruClearPointer = 0;
    private int lruSkipCheckCycle = 0;
    private int pruneAggression = 1;
    private long cacheSize = 0L;
    private boolean cacheLoaded = false;

    public CacheHandler(HentaiAtHomeClient hentaiAtHomeClient) throws IOException {
        this.client = hentaiAtHomeClient;
        this.cachedir = Settings.getCacheDir();
        for (File file : Settings.getTempDir().listFiles()) {
            if (file.isFile()) {
                if (file.getName().startsWith("log_") || file.getName().startsWith("pcache_") || file.getName().equals("client_login")) continue;
                Out.debug("CacheHandler: Deleted orphaned temporary file " + file);
                file.delete();
                continue;
            }
            Out.warning("CacheHandler: Found a non-file " + file + " in the temp directory, won't delete.");
        }
        boolean bl = false;
        if (!Settings.isRescanCache()) {
            Out.info("CacheHandler: Attempting to load persistent cache data...");
            if (this.loadPersistentData()) {
                Out.info("CacheHandler: Successfully loaded persistent cache data");
                bl = true;
            } else {
                Out.info("CacheHandler: Persistent cache data is not available");
            }
        }
        this.deletePersistentData();
        if (!bl) {
            Out.info("CacheHandler: Initializing the cache system...");
            this.startupCacheCleanup();
            System.gc();
            if (hentaiAtHomeClient.isShuttingDown()) {
                return;
            }
            this.lruClearPointer = 0;
            this.cacheCount = 0;
            this.cacheSize = 0L;
            this.staticRangeOldest = new Hashtable((int)((double)Settings.getStaticRangeCount() * 1.5));
            if (!Settings.isUseLessMemory()) {
                this.lruCacheTable = new short[0x100000];
            }
            this.startupInitCache();
            System.gc();
        }
        if (!this.recheckFreeDiskSpace()) {
            hentaiAtHomeClient.setFastShutdown();
            HentaiAtHomeClient.dieWithError("The storage device does not have enough space available to hold the given cache size.\nFree up space for H@H, or reduce the cache size from the H@H settings page:\nhttps://e-hentai.org/hentaiathome.php?cid=" + Settings.getClientID());
        }
        if (this.cacheCount < 1 && Settings.getStaticRangeCount() > 20) {
            hentaiAtHomeClient.setFastShutdown();
            HentaiAtHomeClient.dieWithError("This client has static ranges assigned to it, but the cache is empty. Check file permissions and file system integrity.\nIf the cache has been deleted or is otherwise lost, you have to manually reset your static ranges from the H@H settings page.\nhttps://e-hentai.org/hentaiathome.php?cid=" + Settings.getClientID());
        }
        long l = Settings.getDiskLimitBytes();
        if (this.getCacheSizeWithOverhead() > l) {
            Out.info("CacheHandler: We are over the cache limit, pruning until the limit is met");
            int n = 0;
            DecimalFormat decimalFormat = new DecimalFormat("###.00");
            while (this.getCacheSizeWithOverhead() > l) {
                if (n++ % 100 == 0) {
                    Out.info("CacheHandler: Cache is currently at " + decimalFormat.format(100.0 * (double)this.getCacheSizeWithOverhead() / (double)l) + "%");
                }
                this.recheckFreeDiskSpace();
                System.gc();
            }
            Out.info("CacheHandler: Finished startup cache pruning");
        }
        this.cacheLoaded = true;
    }

    private File getPersistentLRUFile() {
        return new File(Settings.getDataDir(), "pcache_lru");
    }

    private File getPersistentInfoFile() {
        return new File(Settings.getDataDir(), "pcache_info");
    }

    private File getPersistentAgesFile() {
        return new File(Settings.getDataDir(), "pcache_ages");
    }

    private boolean loadPersistentData() {
        if (!this.getPersistentInfoFile().exists()) {
            Out.debug("CacheHandler: Missing pcache_info, forcing rescan");
            return false;
        }
        boolean bl = false;
        try {
            String[] stringArray = Tools.getStringFileContents(this.getPersistentInfoFile()).split("\n");
            int n = 0;
            String string = null;
            String string2 = null;
            block16: for (String string3 : stringArray) {
                String[] stringArray2 = string3.split("=");
                switch (stringArray2[0]) {
                    case "cacheCount": {
                        this.cacheCount = Integer.parseInt(stringArray2[1]);
                        Out.debug("CacheHandler: Loaded persistent cacheCount=" + this.cacheCount);
                        n |= 1;
                        continue block16;
                    }
                    case "cacheSize": {
                        this.cacheSize = Long.parseLong(stringArray2[1]);
                        Out.debug("CacheHandler: Loaded persistent cacheSize=" + this.cacheSize);
                        n |= 2;
                        continue block16;
                    }
                    case "lruClearPointer": {
                        this.lruClearPointer = Integer.parseInt(stringArray2[1]);
                        Out.debug("CacheHandler: Loaded persistent lruClearPointer=" + this.lruClearPointer);
                        n |= 4;
                        continue block16;
                    }
                    case "agesHash": {
                        string = stringArray2[1];
                        Out.debug("CacheHandler: Found agesHash=" + string);
                        n |= 8;
                        continue block16;
                    }
                    case "lruHash": {
                        string2 = stringArray2[1];
                        Out.debug("CacheHandler: Found lruHash=" + string2);
                        n |= 0x10;
                    }
                }
            }
            if (n != 31) {
                Out.info("CacheHandler: Persistent fields were missing, forcing rescan");
            } else {
                Out.info("CacheHandler: All persistent fields found, loading remaining objects");
                this.staticRangeOldest = (Hashtable)this.readCacheObject(this.getPersistentAgesFile(), string);
                Out.info("CacheHandler: Loaded static range ages");
                if (!Settings.isUseLessMemory()) {
                    this.lruCacheTable = (short[])this.readCacheObject(this.getPersistentLRUFile(), string2);
                    Out.info("CacheHandler: Loaded LRU cache");
                }
                this.updateStats();
                bl = true;
            }
        }
        catch (Exception exception) {
            Out.debug(exception.getMessage());
        }
        System.gc();
        return bl;
    }

    private void savePersistentData() {
        if (!this.cacheLoaded) {
            return;
        }
        try {
            String string = this.writeCacheObject(this.getPersistentAgesFile(), this.staticRangeOldest);
            String string2 = this.lruCacheTable == null ? "null" : this.writeCacheObject(this.getPersistentLRUFile(), this.lruCacheTable);
            Tools.putStringFileContents(this.getPersistentInfoFile(), "cacheCount=" + this.cacheCount + "\ncacheSize=" + this.cacheSize + "\nlruClearPointer=" + this.lruClearPointer + "\nagesHash=" + string + "\nlruHash=" + string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Object readCacheObject(File file, String string) throws IOException, ClassNotFoundException {
        if (!file.exists()) {
            Out.warning("CacheHandler: Missing " + file + ", forcing rescan");
            throw new IOException("Missing file");
        }
        if (!Tools.getSHA1String(file).equals(string)) {
            Out.warning("CacheHandler: Incorrect file hash while reading " + file + ", forcing rescan");
            throw new IOException("Incorrect file hash");
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    private String writeCacheObject(File file, Object object) throws FileNotFoundException, IOException {
        Out.debug("Writing cache object " + file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        String string = Tools.getSHA1String(file);
        Out.debug("Wrote cache object " + file + " with size=" + file.length() + " hash=" + string);
        return string;
    }

    private void deletePersistentData() {
        File file = this.getPersistentInfoFile();
        File file2 = this.getPersistentAgesFile();
        File file3 = this.getPersistentLRUFile();
        if (file.exists()) {
            file.delete();
        }
        if (file2.exists()) {
            file2.delete();
        }
        if (file3.exists()) {
            file3.delete();
        }
    }

    public void terminateCache() {
        this.savePersistentData();
    }

    private void startupCacheCleanup() {
        Out.info("CacheHandler: Cache cleanup pass..");
        File[] fileArray = Tools.listSortedFiles(this.cachedir);
        if (fileArray == null) {
            HentaiAtHomeClient.dieWithError("CacheHandler: Unable to access " + this.cachedir + "; check permissions and I/O errors.");
        }
        if (fileArray.length > 5 && Settings.getStaticRangeCount() == 0) {
            Out.warning("WARNING: There are " + fileArray.length + " directories in the cache directory, but the server has only assigned us " + Settings.getStaticRangeCount() + " static ranges.");
            Out.warning("If this is NOT expected, please close H@H with Ctrl+C or Program -> Shutdown H@H before this timeout expires.");
            Out.warning("Waiting 30 seconds before proceeding with cache cleanup...");
            try {
                Thread.currentThread();
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.client.isShuttingDown()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (File file : fileArray) {
            System.gc();
            if (!file.isDirectory()) {
                file.delete();
                continue;
            }
            File[] fileArray2 = Tools.listSortedFiles(file);
            if (fileArray2 == null) {
                Out.warning("CacheHandler: Unable to access " + file + "; check permissions and I/O errors.");
                continue;
            }
            if (fileArray2.length == 0) {
                file.delete();
                continue;
            }
            for (File file2 : fileArray2) {
                if (file2.isDirectory()) continue;
                HVFile hVFile = HVFile.getHVFileFromFile(file2);
                if (hVFile == null) {
                    Out.debug("CacheHandler: The file " + file2 + " was not recognized.");
                    file2.delete();
                    continue;
                }
                if (!Settings.isStaticRange(hVFile.getFileid())) {
                    Out.debug("CacheHandler: The file " + file2 + " was not in an active static range.");
                    file2.delete();
                    continue;
                }
                this.moveFileToCacheDir(file2, hVFile);
                Out.debug("CacheHandler: Relocated file " + hVFile.getFileid() + " to " + hVFile.getLocalFileRef());
            }
            if (fileArray.length <= 9 || ++n * 100 / fileArray.length < n2 + 10) continue;
            Out.info("CacheHandler: Cleanup pass at " + (n2 += 10) + "%");
        }
        Out.info("CacheHandler: Finished scanning " + n + " cache subdirectories");
    }

    private void startupInitCache() {
        int n;
        FileValidator fileValidator = null;
        if (Settings.isVerifyCache()) {
            Out.info("CacheHandler: Loading cache with full file verification. Depending on the size of your cache, this can take a long time.");
            fileValidator = new FileValidator();
            n = 1000;
        } else {
            Out.info("CacheHandler: Loading cache...");
            n = 10000;
        }
        long l = System.currentTimeMillis() - 604800000L;
        int n2 = 0;
        for (File file : Tools.listSortedFiles(this.cachedir)) {
            File[] fileArray;
            if (!file.isDirectory() || (fileArray = Tools.listSortedFiles(file)) == null) continue;
            for (File file2 : fileArray) {
                System.gc();
                if (!file2.isDirectory()) continue;
                File[] fileArray2 = Tools.listSortedFiles(file2);
                if (fileArray2 == null) {
                    Out.warning("CacheHandler: Unable to access " + file2 + "; check permissions and I/O errors.");
                    continue;
                }
                if (fileArray2.length == 0) {
                    file2.delete();
                    continue;
                }
                long l2 = System.currentTimeMillis();
                for (File file3 : fileArray2) {
                    if (!file3.isFile()) continue;
                    HVFile hVFile = HVFile.getHVFileFromFile(file3, fileValidator);
                    if (hVFile == null) {
                        Out.debug("CacheHandler: The file " + file3 + " was corrupt.");
                        file3.delete();
                        continue;
                    }
                    if (!Settings.isStaticRange(hVFile.getFileid())) {
                        Out.debug("CacheHandler: The file " + file3 + " was not in an active static range.");
                        file3.delete();
                        continue;
                    }
                    this.addFileToActiveCache(hVFile);
                    long l3 = file3.lastModified();
                    if (l3 > l) {
                        this.markRecentlyAccessed(hVFile, true);
                    }
                    l2 = Math.min(l2, l3);
                    if (this.cacheCount % n != 0) continue;
                    Out.info("CacheHandler: Loaded " + this.cacheCount + " files so far...");
                }
                String object = file.getName() + file2.getName();
                this.staticRangeOldest.put(object, l2);
                if (++n2 % 100 != 0) continue;
                Out.info("CacheHandler: Found " + n2 + " static ranges with files so far...");
            }
        }
        Out.info("CacheHandler: Finished initializing the cache (" + this.cacheCount + " files, " + this.cacheSize + " apparent bytes, " + this.getCacheSizeWithOverhead() + " estimated bytes on disk)");
        Out.info("CacheHandler: Found a total of " + n2 + " static ranges with files");
        this.updateStats();
    }

    private long getCacheSizeWithOverhead() {
        return this.cacheSize + (long)this.cacheCount * Settings.getFileSystemBlockSize() / 2L;
    }

    public boolean recheckFreeDiskSpace() {
        if (this.lruSkipCheckCycle > 0) {
            --this.lruSkipCheckCycle;
            return true;
        }
        long l = 0x6400000L;
        long l2 = Settings.getDiskLimitBytes();
        long l3 = this.getCacheSizeWithOverhead();
        long l4 = 0L;
        if (l3 > l2) {
            l4 = l + l3 - l2;
        } else if (l2 - l3 < l) {
            l4 = l - (l2 - l3);
        }
        Out.debug("CacheHandler: Checked cache space (cacheSize=" + this.cacheSize + ", cacheSizeWithOverhead=" + l3 + " cacheLimit=" + l2 + ", cacheFree=" + (l2 - l3) + ")");
        if (l4 > 0L && this.cacheCount > 0 && Settings.getStaticRangeCount() > 0) {
            long l5;
            Object object;
            long l6;
            String string = null;
            long l7 = l6 = System.currentTimeMillis();
            Enumeration<String> enumeration = this.staticRangeOldest.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                l5 = this.staticRangeOldest.get(object);
                if (l5 >= l7) continue;
                string = object;
                l7 = l5;
            }
            if (string == null) {
                Out.warning("CacheHandler: Failed to find aged static range to prune (oldestRangeAge=" + l7 + ")");
                return false;
            }
            object = new File(this.cachedir, string.substring(0, 2) + "/" + string.substring(2, 4) + "/");
            l5 = l7;
            l5 = l7 < l6 - 15552000000L ? (l5 += 2592000000L) : (l7 < l6 - 7776000000L ? (l5 += 604800000L) : (l5 += 259200000L));
            Out.debug("CacheHandler: Trying to free " + l4 + " bytes, currently scanning range " + string);
            if (!((File)object).isDirectory()) {
                Out.warning("CacheHandler: Expected static range directory " + object + " could not be accessed");
            } else if (l5 > System.currentTimeMillis() - 604800000L) {
                Out.warning("CacheHandler: Sanity check failed: lruLastModifiedPruneCutoff " + l5 + " is less than a week old, cache pruning halted");
            } else {
                File[] fileArray = ((File)object).listFiles();
                long l8 = l6;
                if (fileArray != null && fileArray.length > 0) {
                    Out.debug("CacheHandler: Examining " + fileArray.length + " files with lruLastModifiedPruneCutoff=" + l5);
                    for (File file : fileArray) {
                        long l9 = file.lastModified();
                        if (l9 < l5) {
                            HVFile hVFile = HVFile.getHVFileFromFileid(file.getName());
                            if (hVFile == null) {
                                Out.warning("CacheHandler: Removed invalid file " + file);
                                file.delete();
                                continue;
                            }
                            this.deleteFileFromCache(hVFile);
                            Out.debug("CacheHandler: Pruned file had lastModified=" + l9 + " size=" + hVFile.getSize() + " bytesToFree=" + (l4 -= (long)hVFile.getSize()) + " cacheCount=" + this.cacheCount);
                            continue;
                        }
                        l8 = Math.min(l8, l9);
                    }
                }
                this.staticRangeOldest.put(string, l8);
                Out.debug("CacheHandler: Updated static range " + string + " with new oldestLastModified=" + l8);
            }
        } else {
            this.lruSkipCheckCycle = l2 - l3 > l * 10L ? 60 : 6;
        }
        int n = this.pruneAggression = l4 > 0xA00000L ? (int)(l4 / 0xA00000L) : 1;
        if (Settings.isSkipFreeSpaceCheck()) {
            Out.debug("CacheHandler: Disk free space check is disabled.");
            return true;
        }
        long l10 = this.cachedir.getFreeSpace();
        if (l10 < Math.max(Settings.getDiskMinRemainingBytes(), l)) {
            Out.warning("CacheHandler: Did not meet space constraints: Disk free space limit reached (" + l10 + " bytes free on device)");
            return false;
        }
        Out.debug("CacheHandler: Disk space constraints met (" + l10 + " bytes free on device)");
        return true;
    }

    public int getPruneAggression() {
        return this.pruneAggression;
    }

    public synchronized void processBlacklist(long l) {
        Out.info("CacheHandler: Retrieving list of blacklisted files...");
        String[] stringArray = this.client.getServerHandler().getBlacklist(l);
        if (stringArray == null) {
            Out.warning("CacheHandler: Failed to retrieve file blacklist, will try again later.");
            return;
        }
        Out.info("CacheHandler: Looking for and deleting blacklisted files...");
        int n = 0;
        for (String string : stringArray) {
            File file;
            HVFile hVFile = HVFile.getHVFileFromFileid(string);
            if (hVFile == null || !(file = hVFile.getLocalFileRef()).exists()) continue;
            this.deleteFileFromCache(hVFile);
            Out.debug("CacheHandler: Removed blacklisted file " + string);
            ++n;
        }
        Out.info("CacheHandler: " + n + " blacklisted files were removed.");
    }

    private void updateStats() {
        Stats.setCacheCount(this.cacheCount);
        Stats.setCacheSize(this.getCacheSizeWithOverhead());
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public boolean importFile(File file, HVFile hVFile) {
        if (this.moveFileToCacheDir(file, hVFile)) {
            this.addFileToActiveCache(hVFile);
            this.markRecentlyAccessed(hVFile, true);
            String string = hVFile.getStaticRange();
            if (!this.staticRangeOldest.containsKey(string)) {
                Out.debug("CacheHandler: Created staticRangeOldest entry for " + string);
                this.staticRangeOldest.put(string, System.currentTimeMillis());
            }
            return true;
        }
        return false;
    }

    private boolean moveFileToCacheDir(File file, HVFile hVFile) {
        File file2 = hVFile.getLocalFileRef();
        try {
            Tools.checkAndCreateDir(file2.getParentFile());
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (file.exists()) {
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                file.delete();
            }
            if (file2.exists()) {
                Out.debug("CacheHandler: Imported file " + file + " as " + hVFile.getFileid());
                return true;
            }
            Out.warning("CacheHandler: Failed to move file " + file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Out.warning("CacheHandler: Encountered exception " + iOException + " when moving file " + file);
        }
        return false;
    }

    private void addFileToActiveCache(HVFile hVFile) {
        ++this.cacheCount;
        this.cacheSize += (long)hVFile.getSize();
        this.updateStats();
    }

    private void deleteFileFromCache(HVFile hVFile) {
        try {
            File file = hVFile.getLocalFileRef();
            if (file.exists()) {
                file.delete();
                --this.cacheCount;
                this.cacheSize -= (long)hVFile.getSize();
                this.updateStats();
                Out.debug("CacheHandler: Deleted cached file " + hVFile.getFileid());
            }
        }
        catch (Exception exception) {
            Out.error("CacheHandler: Failed to delete cache file");
            HentaiAtHomeClient.dieWithError(exception);
        }
    }

    public void cycleLRUCacheTable() {
        if (this.lruCacheTable != null) {
            int n = Math.min(0x100000, this.lruClearPointer + 17);
            while (this.lruClearPointer < n) {
                this.lruCacheTable[this.lruClearPointer++] = 0;
            }
            if (n >= 0x100000) {
                this.lruClearPointer = 0;
            }
        }
    }

    public void markRecentlyAccessed(HVFile hVFile) {
        this.markRecentlyAccessed(hVFile, false);
    }

    public void markRecentlyAccessed(HVFile hVFile, boolean bl) {
        Object object;
        boolean bl2 = true;
        if (this.lruCacheTable != null) {
            short s;
            object = hVFile.getFileid();
            int n = Integer.parseInt(((String)object).substring(4, 9), 16);
            if ((this.lruCacheTable[n] & (s = (short)(1 << Short.parseShort(((String)object).substring(9, 10), 16)))) != 0) {
                bl2 = false;
            } else {
                int n2 = n;
                this.lruCacheTable[n2] = (short)(this.lruCacheTable[n2] | s);
            }
        }
        if (bl2 && !bl) {
            object = hVFile.getLocalFileRef();
            long l = System.currentTimeMillis();
            if (((File)object).lastModified() < l - 604800000L) {
                ((File)object).setLastModified(l);
            }
        }
    }
}

