/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HTTPBandwidthMonitor;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileDownloader
implements Runnable {
    private int timeout = 30000;
    private int maxDLTime = Integer.MAX_VALUE;
    private int retries = 3;
    private long timeDownloadStart = 0L;
    private long timeFirstByte = 0L;
    private long timeDownloadFinish = 0L;
    private ByteBuffer byteBuffer = null;
    private HTTPBandwidthMonitor downloadLimiter = null;
    private Path outputPath = null;
    private URL source;
    private Thread myThread;
    private Object downloadLock = new Object();
    private boolean started = false;
    private boolean discardData = false;

    public FileDownloader(URL uRL, int n, int n2) {
        this.source = uRL;
        this.timeout = n;
        this.maxDLTime = n2;
    }

    public FileDownloader(URL uRL, int n, int n2, boolean bl) {
        this.source = uRL;
        this.timeout = n;
        this.maxDLTime = n2;
        this.discardData = bl;
    }

    public FileDownloader(URL uRL, int n, int n2, Path path) {
        this.source = uRL;
        this.timeout = n;
        this.maxDLTime = n2;
        this.outputPath = path;
    }

    public void setDownloadLimiter(HTTPBandwidthMonitor hTTPBandwidthMonitor) {
        this.downloadLimiter = hTTPBandwidthMonitor;
    }

    public boolean downloadFile() {
        if (this.myThread == null) {
            this.run();
        } else {
            this.waitAsyncDownload();
        }
        return this.timeDownloadFinish > 0L;
    }

    public void startAsyncDownload() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitAsyncDownload() {
        Object object = this.downloadLock;
        synchronized (object) {
        }
        return this.timeDownloadFinish > 0L;
    }

    public String getResponseAsString(String string) {
        if (this.downloadFile() && this.byteBuffer != null) {
            this.byteBuffer.flip();
            byte[] byArray = new byte[this.byteBuffer.remaining()];
            this.byteBuffer.get(byArray);
            try {
                return new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                HentaiAtHomeClient.dieWithError(unsupportedEncodingException);
            }
        }
        return null;
    }

    public long getDownloadTimeMillis() {
        return this.timeFirstByte > 0L ? this.timeDownloadFinish - this.timeFirstByte : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.downloadLock;
        synchronized (object) {
            boolean bl = false;
            if (this.started) {
                return;
            }
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            this.started = true;
            while (!bl && --this.retries >= 0) {
                InputStream inputStream = null;
                try {
                    Out.debug("Connecting to " + this.source.getHost() + "...");
                    URLConnection uRLConnection = this.source.openConnection();
                    uRLConnection.setConnectTimeout(5000);
                    uRLConnection.setReadTimeout(this.timeout);
                    uRLConnection.setRequestProperty("Connection", "Close");
                    uRLConnection.setRequestProperty("User-Agent", "Hentai@Home 1.6.1");
                    uRLConnection.connect();
                    int n = uRLConnection.getContentLength();
                    if (n < 0) {
                        Out.warning("Request host did not send Content-Length, aborting transfer. (" + uRLConnection + ")");
                        Out.warning("Note: A common reason for this is running firewalls with outgoing restrictions or programs like PeerGuardian/PeerBlock. Verify that the remote host is not blocked.");
                        throw new SocketException("Invalid or missing Content-Length");
                    }
                    if (n > 0xA00000 && !this.discardData && this.outputPath == null) {
                        Out.warning("Reported contentLength " + n + " exceeds max allowed size for memory buffer download");
                        throw new SocketException("Reply exceeds expected length");
                    }
                    if (n > Settings.getMaxAllowedFileSize()) {
                        Out.warning("Reported contentLength " + n + " exceeds currently max allowed filesize " + Settings.getMaxAllowedFileSize());
                        throw new SocketException("Reply exceeds expected length");
                    }
                    inputStream = uRLConnection.getInputStream();
                    if (!this.discardData) {
                        if (this.outputPath == null) {
                            if (this.byteBuffer != null && this.byteBuffer.capacity() < n) {
                                this.byteBuffer = null;
                            }
                            if (this.byteBuffer == null) {
                                this.byteBuffer = ByteBuffer.allocateDirect(n);
                            } else {
                                this.byteBuffer.clear();
                            }
                        } else if (abstractInterruptibleChannel == null) {
                            abstractInterruptibleChannel = FileChannel.open(this.outputPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                            Out.debug("FileChannel for output opened");
                        } else {
                            ((FileChannel)abstractInterruptibleChannel).truncate(0L);
                            Out.debug("Truncated open file, set position to " + ((FileChannel)abstractInterruptibleChannel).position());
                        }
                    }
                    Out.debug("Reading " + n + " bytes from " + this.source);
                    this.timeDownloadStart = System.currentTimeMillis();
                    long l = 0L;
                    int n2 = 0;
                    byte[] byArray = new byte[1500];
                    do {
                        if ((n2 = inputStream.read(byArray)) <= 0) continue;
                        if (this.timeFirstByte == 0L) {
                            this.timeFirstByte = System.currentTimeMillis();
                        }
                        if (!this.discardData) {
                            if (this.outputPath == null) {
                                this.byteBuffer.put(byArray, 0, n2);
                            } else {
                                ((FileChannel)abstractInterruptibleChannel).write(ByteBuffer.wrap(byArray, 0, n2));
                            }
                        }
                        l += (long)n2;
                        if (this.downloadLimiter == null) continue;
                        this.downloadLimiter.waitForQuota(Thread.currentThread(), n2);
                    } while (n2 > 0);
                    bl = l == (long)n;
                    this.timeDownloadFinish = System.currentTimeMillis();
                    long l2 = this.getDownloadTimeMillis();
                    Out.debug("Finished in " + l2 + " ms" + (l2 > 0L ? ", speed=" + l / l2 + "KB/s" : "") + ", writeoff=" + l + ", success=" + (bl ? "yes" : "no"));
                    Stats.bytesRcvd(n);
                }
                catch (Exception exception) {
                    if (exception instanceof FileNotFoundException) {
                        Out.warning("Server returned: 404 Not Found");
                        break;
                    }
                    if (exception.getCause() instanceof FileNotFoundException) {
                        Out.warning("Server returned: 404 Not Found");
                        break;
                    }
                    Out.warning(exception.toString());
                    Out.warning("Retrying.. (" + this.retries + " tries left)");
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                    if (!bl) {
                        this.outputPath.toFile().delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                Out.warning("Exhaused retries or aborted getting " + this.source);
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

