/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.FileDownloader;
import hath.base.FileValidator;
import hath.base.HTTPBandwidthMonitor;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.ServerHandler;
import hath.base.Settings;
import hath.base.Stats;
import hath.base.Tools;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class GalleryDownloader
implements Runnable {
    protected HentaiAtHomeClient client;
    private Thread myThread;
    private FileValidator validator;
    protected HTTPBandwidthMonitor downloadLimiter;
    private boolean downloadsAvailable = true;
    private boolean pendingDownload = false;
    private boolean markDownloaded = false;
    private String title;
    private String information;
    private GalleryFile[] galleryFiles;
    private List<String> failures;
    protected int gid;
    protected int filecount;
    protected String minxres;
    protected File todir;

    public GalleryDownloader(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.validator = new FileValidator();
        this.downloadLimiter = Settings.isDisableDownloadBWM() ? null : new HTTPBandwidthMonitor();
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    @Override
    public void run() {
        while (!this.client.isShuttingDown() && this.downloadsAvailable) {
            if (!this.pendingDownload) {
                this.pendingDownload = this.initializeNewGalleryMeta();
            }
            if (!this.pendingDownload) {
                this.downloadsAvailable = false;
                break;
            }
            Out.info("GalleryDownloader: Starting download of gallery: " + this.title);
            int n = 0;
            boolean bl = false;
            while (!bl && ++n < 10) {
                int n2 = 0;
                for (GalleryFile galleryFile : this.galleryFiles) {
                    if (this.client.isShuttingDown()) break;
                    long l = 0L;
                    if (this.client.isSuspended()) {
                        l = 60000L;
                    } else if (this.downloadDirectoryHasLowSpace()) {
                        Out.warning("GalleryDownloader: Download suspended; there is less than the minimum allowed space left on the storage device.");
                        l = 300000L;
                    } else {
                        int n3 = galleryFile.download();
                        if (n3 == 1) {
                            ++n2;
                            l = 1000L;
                        } else if (n3 == 2) {
                            ++n2;
                        } else if (n3 == 0) {
                            l = 5000L;
                        }
                    }
                    if (l <= 0L) continue;
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (n2 != this.filecount) continue;
                bl = true;
            }
            this.finalizeGalleryDownload(bl);
        }
        Out.info("GalleryDownloader: Download thread finished.");
        this.client.deleteDownloader();
    }

    private boolean downloadDirectoryHasLowSpace() {
        return !Settings.isSkipFreeSpaceCheck() && Settings.getDownloadDir().getFreeSpace() < Settings.getDiskMinRemainingBytes() + 1048576000L;
    }

    private void finalizeGalleryDownload(boolean bl) {
        this.pendingDownload = false;
        this.markDownloaded = true;
        if (bl) {
            Out.info("GalleryDownloader: Finished download of gallery: " + this.title);
            try {
                Tools.putStringFileContents(new File(this.todir, "galleryinfo.txt"), this.information, "UTF8");
            }
            catch (IOException iOException) {
                Out.warning("GalleryDownloader: Could not write galleryinfo file");
                iOException.printStackTrace();
            }
        } else {
            Out.warning("GalleryDownloader: Permanently failed downloading gallery: " + this.title);
        }
    }

    private boolean initializeNewGalleryMeta() {
        URL uRL;
        if (this.markDownloaded && this.failures != null) {
            this.client.getServerHandler().reportDownloaderFailures(this.failures);
        }
        try {
            uRL = new URL("http://" + Settings.getRPCServerHost() + "/15/dl?" + ServerHandler.getURLQueryString("fetchqueue", this.markDownloaded ? this.gid + ";" + this.minxres : ""));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        FileDownloader fileDownloader = new FileDownloader(uRL, 30000, 30000);
        String string = fileDownloader.getResponseAsString("UTF8");
        if (string == null) {
            return false;
        }
        if (string.equals("INVALID_REQUEST")) {
            Out.warning("GalleryDownloader: Request was rejected by the server");
            return false;
        }
        if (string.equals("NO_PENDING_DOWNLOADS")) {
            return false;
        }
        Out.debug("GalleryDownloader: Started gallery metadata parsing");
        this.gid = 0;
        this.filecount = 0;
        this.minxres = null;
        this.title = null;
        this.information = "";
        this.galleryFiles = null;
        this.todir = null;
        this.markDownloaded = false;
        this.failures = null;
        int n = 0;
        try {
            for (String string2 : string.split("\n")) {
                String[] stringArray;
                if (string2.equals("FILELIST") && n == 0) {
                    n = 1;
                    continue;
                }
                if (string2.equals("INFORMATION") && n == 1) {
                    n = 2;
                    continue;
                }
                if (n < 2 && string2.isEmpty()) continue;
                if (n == 0) {
                    stringArray = string2.split(" ", 2);
                    if (stringArray[0].equals("GID")) {
                        this.gid = Integer.parseInt(stringArray[1]);
                        Out.debug("GalleryDownloader: Parsed gid=" + this.gid);
                        continue;
                    }
                    if (stringArray[0].equals("FILECOUNT")) {
                        this.filecount = Integer.parseInt(stringArray[1]);
                        this.galleryFiles = new GalleryFile[this.filecount];
                        Out.debug("GalleryDownloader: Parsed filecount=" + this.filecount);
                        continue;
                    }
                    if (stringArray[0].equals("MINXRES")) {
                        if (Pattern.matches("^org|\\d+$", stringArray[1])) {
                            this.minxres = stringArray[1];
                            Out.debug("GalleryDownloader: Parsed minxres=" + this.minxres);
                            continue;
                        }
                        throw new Exception("Encountered invalid minxres");
                    }
                    if (!stringArray[0].equals("TITLE")) continue;
                    this.title = stringArray[1].replaceAll("(\\*|\\\"|\\\\|<|>|:\\|\\?)", "").replaceAll("\\s+", " ").replaceAll("(^\\s+|\\s+$)", "");
                    Out.debug("GalleryDownloader: Parsed title=" + this.title);
                    String string3 = this.minxres.equals("org") ? "" : "-" + this.minxres + "x";
                    this.todir = this.title.length() > 100 ? new File(Settings.getDownloadDir(), this.title.substring(0, 97) + "... [" + this.gid + string3 + "]") : new File(Settings.getDownloadDir(), this.title + " [" + this.gid + string3 + "]");
                    if (!this.todir.getParentFile().equals(Settings.getDownloadDir())) {
                        Out.warning("GalleryDownloader: Unexpected download location.");
                        this.todir = null;
                        break;
                    }
                    try {
                        Tools.checkAndCreateDir(this.todir);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.todir.exists()) {
                        Out.warning("GalleryDownloader: Could not create gallery download directory \"" + this.todir.getName() + "\". Your filesystem may not support Unicode. Attempting fallback.");
                        this.todir = new File(Settings.getDownloadDir(), this.gid + string3);
                        Tools.checkAndCreateDir(this.todir);
                    }
                    Out.debug("GalleryDownloader: Created directory " + this.todir);
                    continue;
                }
                if (n == 1) {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    int n2;
                    stringArray = string2.split(" ", 6);
                    int n3 = Integer.parseInt(stringArray[0]);
                    GalleryFile galleryFile = new GalleryFile(n3, n2 = Integer.parseInt(stringArray[1]), string7 = stringArray[2], string6 = stringArray[3].equals("unknown") ? null : stringArray[3], string5 = stringArray[4], string4 = stringArray[5]);
                    if (galleryFile == null) continue;
                    Out.debug("GalleryDownloader: Parsed file " + galleryFile);
                    this.galleryFiles[n3 - 1] = galleryFile;
                    continue;
                }
                this.information = this.information.concat(string2).concat(Settings.NEWLINE);
            }
        }
        catch (Exception exception) {
            Out.warning("GalleryDownloader: Failed to parse metadata for new gallery");
            exception.printStackTrace();
            return false;
        }
        return this.gid > 0 && this.filecount > 0 && this.minxres != null && this.title != null && this.todir != null && this.galleryFiles != null;
    }

    protected void logFailure(String string) {
        if (this.failures == null) {
            this.failures = Collections.checkedList(new ArrayList(), String.class);
        }
        if (!this.failures.contains(string)) {
            this.failures.add(string);
        }
    }

    private class GalleryFile {
        public static final int STATE_DOWNLOAD_FAILED = 0;
        public static final int STATE_DOWNLOAD_SUCCESSFUL = 1;
        public static final int STATE_ALREADY_DOWNLOADED = 2;
        private File tofile;
        private String filetype;
        private String filename;
        private String xres;
        private String expectedSHA1Hash;
        private int page;
        private int fileindex;
        private int fileretry = 0;
        private boolean fileComplete = false;

        public GalleryFile(int n, int n2, String string, String string2, String string3, String string4) {
            this.page = n;
            this.fileindex = n2;
            this.xres = string;
            this.expectedSHA1Hash = string2;
            this.filetype = string3;
            this.filename = string4;
            this.tofile = new File(GalleryDownloader.this.todir, string4 + "." + string3);
        }

        public int download() {
            URL uRL;
            if (this.fileComplete) {
                return 2;
            }
            if (this.tofile.isFile()) {
                boolean bl = false;
                if (this.tofile.length() > 0L) {
                    try {
                        if (this.expectedSHA1Hash == null) {
                            bl = true;
                        } else if (GalleryDownloader.this.validator.validateFile(this.tofile.toPath(), this.expectedSHA1Hash)) {
                            bl = true;
                            Out.debug("GalleryDownloader: Verified SHA-1 hash for " + this + ": " + this.expectedSHA1Hash);
                        }
                    }
                    catch (IOException iOException) {
                        Out.warning("GalleryDownloader: Encountered I/O error while validating " + this.tofile);
                        iOException.printStackTrace();
                    }
                }
                if (bl) {
                    this.fileComplete = true;
                    return 2;
                }
                this.tofile.delete();
            }
            if ((uRL = GalleryDownloader.this.client.getServerHandler().getDownloaderFetchURL(GalleryDownloader.this.gid, this.page, this.fileindex, this.xres, ++this.fileretry > 1)) != null) {
                FileDownloader fileDownloader = new FileDownloader(uRL, 10000, 300000, this.tofile.toPath());
                fileDownloader.setDownloadLimiter(GalleryDownloader.this.downloadLimiter);
                this.fileComplete = fileDownloader.downloadFile();
                try {
                    if (this.fileComplete && this.expectedSHA1Hash != null) {
                        if (!GalleryDownloader.this.validator.validateFile(this.tofile.toPath(), this.expectedSHA1Hash)) {
                            this.fileComplete = false;
                            this.tofile.delete();
                            Out.debug("GalleryDownloader: Corrupted download for " + this + ", forcing retry");
                        } else {
                            Out.debug("GalleryDownloader: Verified SHA-1 hash for " + this + ": " + this.expectedSHA1Hash);
                        }
                    }
                }
                catch (IOException iOException) {
                    Out.warning("GalleryDownloader: Encountered I/O error while validating " + this.tofile);
                    iOException.printStackTrace();
                    this.fileComplete = false;
                    this.tofile.delete();
                }
                Out.debug("GalleryDownloader: Download of " + this + " " + (this.fileComplete ? "successful" : "FAILED") + " (attempt=" + this.fileretry + ")");
                if (this.fileComplete) {
                    Stats.fileRcvd();
                    Out.info("GalleryDownloader: Finished downloading gid=" + GalleryDownloader.this.gid + " page=" + this.page + ": " + this.filename + "." + this.filetype);
                } else {
                    GalleryDownloader.this.logFailure(uRL.getHost() + "-" + this.fileindex + "-" + this.xres);
                }
            }
            return this.fileComplete ? 1 : 0;
        }

        public String toString() {
            return "gid=" + GalleryDownloader.this.gid + " page=" + this.page + " fileindex=" + this.fileindex + " xres=" + this.xres + " filetype=" + this.filetype + " filename=" + this.filename;
        }
    }
}

