/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.FileDownloader;
import hath.base.HTTPResponseProcessor;
import hath.base.HTTPResponseProcessorFile;
import hath.base.HTTPResponseProcessorProxy;
import hath.base.HTTPResponseProcessorSpeedtest;
import hath.base.HTTPResponseProcessorText;
import hath.base.HTTPSession;
import hath.base.HVFile;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import hath.base.Tools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;

public class HTTPResponse {
    private static final Pattern absoluteUriPattern = Pattern.compile("^http://[^/]+/", 2);
    private HTTPSession session;
    private boolean requestHeadOnly;
    private boolean servercmd;
    private int responseStatusCode;
    private HTTPResponseProcessor hpc;

    public HTTPResponse(HTTPSession hTTPSession) {
        this.session = hTTPSession;
        this.servercmd = false;
        this.requestHeadOnly = false;
        this.responseStatusCode = 500;
    }

    private HTTPResponseProcessor processRemoteAPICommand(String string, String string2) {
        Hashtable<String, String> hashtable = Tools.parseAdditional(string2);
        HentaiAtHomeClient hentaiAtHomeClient = this.session.getHTTPServer().getHentaiAtHomeClient();
        try {
            if (string.equalsIgnoreCase("still_alive")) {
                return new HTTPResponseProcessorText("I feel FANTASTIC and I'm still alive");
            }
            if (string.equalsIgnoreCase("threaded_proxy_test")) {
                return this.processThreadedProxyTest(hashtable);
            }
            if (string.equalsIgnoreCase("speed_test")) {
                String string3 = hashtable.get("testsize");
                return new HTTPResponseProcessorSpeedtest(string3 != null ? Integer.parseInt(string3) : 1000000);
            }
            if (string.equalsIgnoreCase("refresh_settings")) {
                hentaiAtHomeClient.getServerHandler().refreshServerSettings();
                return new HTTPResponseProcessorText("");
            }
            if (string.equalsIgnoreCase("start_downloader")) {
                hentaiAtHomeClient.startDownloader();
                return new HTTPResponseProcessorText("");
            }
            if (string.equalsIgnoreCase("refresh_certs")) {
                hentaiAtHomeClient.setCertRefresh();
                return new HTTPResponseProcessorText("");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Out.warning(this.session + " Failed to process command");
        }
        return new HTTPResponseProcessorText("INVALID_COMMAND");
    }

    private HTTPResponseProcessorText processThreadedProxyTest(Hashtable<String, String> hashtable) {
        String string = hashtable.get("hostname");
        String string2 = hashtable.get("protocol");
        int n = Integer.parseInt(hashtable.get("port"));
        int n2 = Integer.parseInt(hashtable.get("testsize"));
        int n3 = Integer.parseInt(hashtable.get("testcount"));
        int n4 = Integer.parseInt(hashtable.get("testtime"));
        String string3 = hashtable.get("testkey");
        Out.debug("Running threaded proxy test against hostname=" + string + " protocol=" + string2 + " port=" + n + " testsize=" + n2 + " testcount=" + n3 + " testtime=" + n4 + " testkey=" + string3);
        int n5 = 0;
        long l = 0L;
        try {
            List<FileDownloader> list = Collections.checkedList(new ArrayList(), FileDownloader.class);
            for (int i = 0; i < n3; ++i) {
                URL object = new URL(string2 == null ? "http" : string2, string, n, "/t/" + n2 + "/" + n4 + "/" + string3 + "/" + (int)Math.floor(Math.random() * 2.147483647E9));
                Out.debug("Test thread: " + object);
                FileDownloader fileDownloader = new FileDownloader(object, 10000, 60000, true);
                list.add(fileDownloader);
                fileDownloader.startAsyncDownload();
            }
            for (FileDownloader fileDownloader : list) {
                if (!fileDownloader.waitAsyncDownload()) continue;
                ++n5;
                l += fileDownloader.getDownloadTimeMillis();
            }
        }
        catch (MalformedURLException malformedURLException) {
            HentaiAtHomeClient.dieWithError(malformedURLException);
        }
        return new HTTPResponseProcessorText("OK:" + n5 + "-" + l);
    }

    public void parseRequest(String string, boolean bl) {
        if (string == null) {
            Out.debug(this.session + " Client did not send a request.");
            this.responseStatusCode = 400;
            return;
        }
        String[] stringArray = string.trim().split(" ", 3);
        if (stringArray.length != 3) {
            Out.debug(this.session + " Invalid HTTP request form.");
            this.responseStatusCode = 400;
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("GET") && !stringArray[0].equalsIgnoreCase("HEAD") || !stringArray[2].startsWith("HTTP/")) {
            Out.debug(this.session + " HTTP request is not GET or HEAD.");
            this.responseStatusCode = 405;
            return;
        }
        stringArray[1] = absoluteUriPattern.matcher(stringArray[1]).replaceFirst("/");
        String[] stringArray2 = stringArray[1].replace("%3d", "=").split("/");
        if (stringArray2.length < 2 || !stringArray2[0].equals("")) {
            Out.debug(this.session + " The requested URL is invalid or not supported.");
            this.responseStatusCode = 404;
            return;
        }
        this.requestHeadOnly = stringArray[0].equalsIgnoreCase("HEAD");
        if (stringArray2[1].equals("h")) {
            Object object;
            if (stringArray2.length < 4) {
                this.responseStatusCode = 400;
                return;
            }
            String string2 = stringArray2[2];
            HVFile hVFile = HVFile.getHVFileFromFileid(string2);
            Hashtable<String, String> hashtable = Tools.parseAdditional(stringArray2[3]);
            boolean bl2 = true;
            try {
                object = hashtable.get("keystamp").split("-");
                if (((String[])object).length == 2) {
                    int n = Integer.parseInt(object[0]);
                    if (Math.abs(Settings.getServerTime() - n) < 900 && object[1].equalsIgnoreCase(Tools.getSHA1String(n + "-" + string2 + "-" + Settings.getClientKey() + "-hotlinkthis").substring(0, 10))) {
                        bl2 = false;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = hashtable.get("fileindex");
            String string3 = hashtable.get("xres");
            if (bl2) {
                this.responseStatusCode = 403;
            } else if (hVFile == null || object == null || string3 == null || !Pattern.matches("^\\d+$", (CharSequence)object) || !Pattern.matches("^org|\\d+$", string3)) {
                Out.debug(this.session + " Invalid or missing arguments.");
                this.responseStatusCode = 404;
            } else if (hVFile.getLocalFileRef().exists()) {
                this.hpc = new HTTPResponseProcessorFile(hVFile);
                this.session.getHTTPServer().getHentaiAtHomeClient().getCacheHandler().markRecentlyAccessed(hVFile);
            } else if (Settings.isStaticRange(string2)) {
                URL[] uRLArray = this.session.getHTTPServer().getHentaiAtHomeClient().getServerHandler().getStaticRangeFetchURL((String)object, string3, string2);
                if (uRLArray == null) {
                    this.responseStatusCode = 404;
                } else {
                    this.hpc = new HTTPResponseProcessorProxy(this.session, string2, uRLArray);
                }
            } else {
                this.responseStatusCode = 404;
            }
            return;
        }
        if (stringArray2[1].equals("servercmd")) {
            if (!Settings.isValidRPCServer(this.session.getSocketInetAddress())) {
                Out.debug(this.session + " Got a servercmd from an unauthorized IP address");
                this.responseStatusCode = 403;
                return;
            }
            if (stringArray2.length < 6) {
                Out.debug(this.session + " Got a malformed servercmd");
                this.responseStatusCode = 403;
                return;
            }
            String string4 = stringArray2[2];
            String string5 = stringArray2[3];
            int n = Integer.parseInt(stringArray2[4]);
            String string6 = stringArray2[5];
            if (Math.abs(n - Settings.getServerTime()) > 300 || !Tools.getSHA1String("hentai@home-servercmd-" + string4 + "-" + string5 + "-" + Settings.getClientID() + "-" + n + "-" + Settings.getClientKey()).equals(string6)) {
                Out.debug(this.session + " Got a servercmd with expired or incorrect key");
                this.responseStatusCode = 403;
                return;
            }
            this.responseStatusCode = 200;
            this.servercmd = true;
            this.hpc = this.processRemoteAPICommand(string4, string5);
            return;
        }
        if (stringArray2[1].equals("t")) {
            if (stringArray2.length < 5) {
                this.responseStatusCode = 400;
                return;
            }
            int n = Integer.parseInt(stringArray2[2]);
            int n2 = Integer.parseInt(stringArray2[3]);
            String string7 = stringArray2[4];
            if (Math.abs(n2 - Settings.getServerTime()) > 300) {
                Out.debug(this.session + " Got a speedtest request with expired key");
                this.responseStatusCode = 403;
                return;
            }
            if (!Tools.getSHA1String("hentai@home-speedtest-" + n + "-" + n2 + "-" + Settings.getClientID() + "-" + Settings.getClientKey()).equals(string7)) {
                Out.debug(this.session + " Got a speedtest request with invalid key");
                this.responseStatusCode = 403;
                return;
            }
            Out.debug("Sending threaded proxy test with testsize=" + n + " testtime=" + n2 + " testkey=" + string7);
            this.responseStatusCode = 200;
            this.hpc = new HTTPResponseProcessorSpeedtest(n);
            return;
        }
        if (stringArray2.length == 2) {
            if (stringArray2[1].equals("favicon.ico")) {
                this.hpc = new HTTPResponseProcessorText("");
                this.hpc.addHeaderField("Location", "https://e-hentai.org/favicon.ico");
                this.responseStatusCode = 301;
                return;
            }
            if (stringArray2[1].equals("robots.txt")) {
                this.hpc = new HTTPResponseProcessorText("User-agent: *\nDisallow: /", "text/plain");
                this.responseStatusCode = 200;
                return;
            }
        }
        Out.debug(this.session + " Invalid request type '" + stringArray2[1]);
        this.responseStatusCode = 404;
    }

    public HTTPResponseProcessor getHTTPResponseProcessor() {
        if (this.hpc == null) {
            this.hpc = new HTTPResponseProcessorText("An error has occurred. (" + this.responseStatusCode + ")");
            if (this.responseStatusCode == 405) {
                this.hpc.addHeaderField("Allow", "GET,HEAD");
            }
        } else if (this.hpc instanceof HTTPResponseProcessorFile) {
            this.responseStatusCode = this.hpc.initialize();
        } else if (this.hpc instanceof HTTPResponseProcessorProxy) {
            this.responseStatusCode = this.hpc.initialize();
        } else if (this.hpc instanceof HTTPResponseProcessorSpeedtest) {
            Stats.setProgramStatus("Running speed tests...");
        }
        return this.hpc;
    }

    public void requestCompleted() {
        this.hpc.requestCompleted();
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public boolean isRequestHeadOnly() {
        return this.requestHeadOnly;
    }

    public boolean isServercmd() {
        return this.servercmd;
    }
}

