/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HTTPResponseProcessor;
import hath.base.HVFile;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class HTTPResponseProcessorFile
extends HTTPResponseProcessor {
    private HVFile requestedHVFile;
    private FileChannel fileChannel;
    private ByteBuffer fileBuffer;
    private int readoff = 0;

    public HTTPResponseProcessorFile(HVFile hVFile) {
        this.requestedHVFile = hVFile;
    }

    @Override
    public int initialize() {
        int n = 0;
        try {
            this.fileChannel = FileChannel.open(this.requestedHVFile.getLocalFilePath(), StandardOpenOption.READ);
            this.fileBuffer = ByteBuffer.allocateDirect(Settings.isUseLessMemory() ? 8192 : 65536);
            this.fileChannel.read(this.fileBuffer);
            this.fileBuffer.flip();
            n = 200;
            Stats.fileSent();
        }
        catch (IOException iOException) {
            Out.warning("Failed reading content from " + this.requestedHVFile.getLocalFilePath());
            n = 500;
        }
        return n;
    }

    @Override
    public void cleanup() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getContentType() {
        return this.requestedHVFile.getMimeType();
    }

    @Override
    public int getContentLength() {
        if (this.fileChannel != null) {
            return this.requestedHVFile.getSize();
        }
        return 0;
    }

    @Override
    public ByteBuffer getPreparedTCPBuffer() throws Exception {
        int n = Math.min(this.getContentLength() - this.readoff, 1460);
        if (n > this.fileBuffer.remaining()) {
            int n2 = 0;
            this.fileBuffer.compact();
            while (n > this.fileBuffer.position()) {
                n2 += this.fileChannel.read(this.fileBuffer);
            }
            this.fileBuffer.flip();
        }
        ByteBuffer byteBuffer = this.fileBuffer.slice();
        byteBuffer.limit(byteBuffer.position() + n);
        this.fileBuffer.position(this.fileBuffer.position() + n);
        this.readoff += n;
        return byteBuffer;
    }
}

