/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HTTPResponseProcessor;
import hath.base.HTTPSession;
import hath.base.Out;
import hath.base.ProxyFileDownloader;
import java.net.URL;
import java.nio.ByteBuffer;

public class HTTPResponseProcessorProxy
extends HTTPResponseProcessor {
    private HTTPSession session;
    private ProxyFileDownloader proxyDownloader;
    private int readoff = 0;
    private ByteBuffer tcpBuffer;

    public HTTPResponseProcessorProxy(HTTPSession hTTPSession, String string, URL[] uRLArray) {
        this.session = hTTPSession;
        this.proxyDownloader = new ProxyFileDownloader(hTTPSession.getHTTPServer().getHentaiAtHomeClient(), string, uRLArray);
    }

    @Override
    public int initialize() {
        Out.debug(this.session + ": Initializing proxy request...");
        this.tcpBuffer = ByteBuffer.allocateDirect(1460);
        return this.proxyDownloader.initialize();
    }

    @Override
    public String getContentType() {
        return this.proxyDownloader.getContentType();
    }

    @Override
    public int getContentLength() {
        return this.proxyDownloader.getContentLength();
    }

    @Override
    public ByteBuffer getPreparedTCPBuffer() throws Exception {
        this.tcpBuffer.clear();
        int n = 0;
        int n2 = Math.min(this.getContentLength(), this.readoff + this.tcpBuffer.limit());
        while (n2 > this.proxyDownloader.getCurrentWriteoff()) {
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++n <= 30000) continue;
            throw new Exception("Timeout while waiting for proxy request.");
        }
        int n3 = this.proxyDownloader.fillBuffer(this.tcpBuffer, this.readoff);
        this.readoff += n3;
        this.tcpBuffer.flip();
        return this.tcpBuffer;
    }

    @Override
    public void requestCompleted() {
        this.proxyDownloader.proxyThreadCompleted();
    }
}

