/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HTTPResponseProcessor;
import hath.base.Out;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class HTTPResponseProcessorText
extends HTTPResponseProcessor {
    private byte[] responseBytes;
    private int writeoff = 0;
    private String contentType;

    public HTTPResponseProcessorText(String string) {
        this(string, "text/html");
    }

    public HTTPResponseProcessorText(String string, String string2) {
        this(string, string2, Charset.forName("ISO-8859-1"));
    }

    public HTTPResponseProcessorText(String string, String string2, Charset charset) {
        int n = string.length();
        if (n > 0) {
            Out.debug("Response Written:");
            if (n < 10000) {
                Out.debug(string);
            } else {
                Out.debug("tl;dw");
            }
        }
        this.responseBytes = string.getBytes(charset);
        this.contentType = string2 + "; charset=" + charset.name();
    }

    @Override
    public int getContentLength() {
        if (this.responseBytes != null) {
            return this.responseBytes.length;
        }
        return 0;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public ByteBuffer getPreparedTCPBuffer() throws Exception {
        int n = Math.min(this.getContentLength() - this.writeoff, 1460);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.responseBytes, this.writeoff, n);
        this.writeoff += n;
        return byteBuffer;
    }
}

