/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.FileDownloader;
import hath.base.HTTPBandwidthMonitor;
import hath.base.HTTPSession;
import hath.base.HTTPSessionKiller;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.ServerHandler;
import hath.base.Settings;
import hath.base.Stats;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class HTTPServer
implements Runnable {
    private HentaiAtHomeClient client;
    private HTTPBandwidthMonitor bandwidthMonitor = null;
    private SSLServerSocket listener = null;
    private SSLContext sslContext = null;
    private Thread myThread = null;
    private List<HTTPSession> sessions;
    private int sessionCount = 0;
    private int currentConnId = 0;
    private boolean allowNormalConnections = false;
    private boolean isRestarting = false;
    private boolean isTerminated = false;
    private Hashtable<String, FloodControlEntry> floodControlTable;
    private Pattern localNetworkPattern;
    private Date certExpiry;

    public HTTPServer(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.sessions = Collections.checkedList(new ArrayList(), HTTPSession.class);
        this.floodControlTable = new Hashtable();
        if (!Settings.isDisableBWM()) {
            this.bandwidthMonitor = new HTTPBandwidthMonitor();
        }
        this.localNetworkPattern = Pattern.compile("^((localhost)|(127\\.)|(10\\.)|(192\\.168\\.)|(172\\.((1[6-9])|(2[0-9])|(3[0-1]))\\.)|(169\\.254\\.)|(::1)|(0:0:0:0:0:0:0:1)|(fc)|(fd)).*$");
    }

    public boolean startConnectionListener(int n) {
        try {
            String string = Settings.getClientKey();
            Out.info("Requesting certificate from server...");
            File file = new File(Settings.getDataDir(), "hathcert.p12");
            URL uRL = ServerHandler.getServerConnectionURL("get_cert");
            FileDownloader fileDownloader = new FileDownloader(uRL, 10000, 300000, file.toPath());
            fileDownloader.downloadFile();
            if (!file.exists()) {
                Out.error("Could not retrieve certificate file " + file);
                return false;
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fileInputStream = new FileInputStream(file.getPath());
            keyStore.load(fileInputStream, string.toCharArray());
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate("hath.network");
            this.certExpiry = x509Certificate.getNotAfter();
            Out.debug("Initialized KeyStore with cert=" + x509Certificate.toString());
            if (this.isCertExpired()) {
                Out.error("The retrieved certificate is expired, or the system time is off by more than a day. Correct the system time and try again.");
                return false;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            Out.debug("Initialized TrustManagerFactory with algorithm=" + trustManagerFactory.getAlgorithm());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, string.toCharArray());
            Out.debug("Initialized KeyManagerFactory with algorithm=" + keyManagerFactory.getAlgorithm());
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            Out.info("Starting up the internal HTTP Server...");
            SSLServerSocketFactory sSLServerSocketFactory = this.sslContext.getServerSocketFactory();
            this.listener = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
            this.listener.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"});
            Out.debug("Initialized SSLContext with cert " + file + " and protocol " + this.sslContext.getProtocol());
            Out.debug("Supported ciphers: " + Arrays.toString(this.sslContext.getSupportedSSLParameters().getCipherSuites()));
            Out.debug("Enabled protocols: " + Arrays.toString(this.listener.getEnabledProtocols()));
            this.myThread = new Thread(this);
            this.myThread.start();
            Out.info("Internal HTTP Server was successfully started, and is listening on port " + n);
            return true;
        }
        catch (Exception exception) {
            this.allowNormalConnections();
            exception.printStackTrace();
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("Could not start the internal HTTP server.");
            Out.info("This is most likely caused by something else running on port " + n + ", which H@H is trying to use.");
            Out.info("In order to fix this, either shut down whatever else is using the port, or assign a different port to H@H.");
            if (n < 1024) {
                Out.info("It could also be caused by trying to use port " + n + " on a system that disallows non-root users from binding to low ports.");
                Out.info("For information on how to work around this, read this post: https://forums.e-hentai.org/index.php?showtopic=232693");
            }
            Out.info("************************************************************************************************************************************");
            Out.info("");
            return false;
        }
    }

    public boolean isCertExpired() {
        Date date = new Date();
        Out.debug("Current system time is " + date + " (" + date.getTime() + ")");
        Out.debug("Certificate expires on " + this.certExpiry + " (" + this.certExpiry.getTime() + ")");
        return this.certExpiry.getTime() < date.getTime() + 86400000L;
    }

    public void stopConnectionListener(boolean bl) {
        this.isRestarting = bl;
        if (this.listener != null) {
            try {
                this.listener.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneFloodControlTable() {
        List<String> list = Collections.checkedList(new ArrayList(), String.class);
        Hashtable<String, FloodControlEntry> hashtable = this.floodControlTable;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.floodControlTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!this.floodControlTable.get(string).isStale()) continue;
                list.add(string);
            }
            for (String string : list) {
                this.floodControlTable.remove(string);
            }
        }
        list.clear();
        list = null;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nukeOldConnections() {
        List<HTTPSession> list = Collections.checkedList(new ArrayList(), HTTPSession.class);
        List<HTTPSession> list2 = this.sessions;
        synchronized (list2) {
            for (HTTPSession hTTPSession : this.sessions) {
                if (!hTTPSession.doTimeoutCheck()) continue;
                Out.debug("Adding session " + hTTPSession + " to timeout kill queue");
                list.add(hTTPSession);
            }
            for (HTTPSession hTTPSession : list) {
                this.removeHTTPSession(hTTPSession);
            }
        }
        if (!list.isEmpty()) {
            new HTTPSessionKiller(list).satsuriku();
        }
    }

    public void allowNormalConnections() {
        this.allowNormalConnections = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                Object object;
                SSLSocket sSLSocket = (SSLSocket)this.listener.accept();
                boolean bl = false;
                InetAddress inetAddress = sSLSocket.getInetAddress();
                String string = inetAddress.getHostAddress().toLowerCase();
                boolean bl2 = Settings.getClientHost().replace("::ffff:", "").equals(string) || this.localNetworkPattern.matcher(string).matches();
                boolean bl3 = Settings.isValidRPCServer(inetAddress);
                if (!bl3 && !this.allowNormalConnections) {
                    Out.warning("Rejecting connection request from " + string + " during startup.");
                    bl = true;
                } else if (!bl3 && !bl2) {
                    int n = Settings.getMaxConnections();
                    if (this.sessionCount > n) {
                        Out.warning("Exceeded the maximum allowed number of incoming connections (" + n + ").");
                        bl = true;
                    } else {
                        if ((double)this.sessionCount > (double)n * 0.8) {
                            this.client.getServerHandler().notifyOverload();
                        }
                        if (!Settings.isDisableFloodControl()) {
                            object = null;
                            Hashtable<String, FloodControlEntry> hashtable = this.floodControlTable;
                            // MONITORENTER : hashtable
                            object = this.floodControlTable.get(string);
                            if (object == null) {
                                object = new FloodControlEntry(inetAddress);
                                this.floodControlTable.put(string, (FloodControlEntry)object);
                            }
                            // MONITOREXIT : hashtable
                            if (!((FloodControlEntry)object).isBlocked()) {
                                if (!((FloodControlEntry)object).hit()) {
                                    Out.warning("Flood control activated for  " + string + " (blocking for 60 seconds)");
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        }
                    }
                }
                if (bl) {
                    try {
                        sSLSocket.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                HTTPSession hTTPSession = new HTTPSession(sSLSocket, this.getNewConnId(), bl2, this);
                object = this.sessions;
                // MONITORENTER : object
                this.sessions.add(hTTPSession);
                this.sessionCount = this.sessions.size();
                // MONITOREXIT : object
                Stats.setOpenConnections(this.sessionCount);
                hTTPSession.handleSession();
            }
        }
        catch (IOException iOException) {
            if (!this.isRestarting && !this.client.isShuttingDown()) {
                Out.error("ServerSocket terminated unexpectedly!");
                HentaiAtHomeClient.dieWithError(iOException);
            } else {
                Out.info("ServerSocket was closed and will no longer accept new connections.");
            }
            this.listener = null;
            this.isTerminated = true;
            return;
        }
    }

    public boolean isThreadTerminated() {
        return this.isTerminated;
    }

    private synchronized int getNewConnId() {
        return ++this.currentConnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHTTPSession(HTTPSession hTTPSession) {
        List<HTTPSession> list = this.sessions;
        synchronized (list) {
            this.sessions.remove(hTTPSession);
            this.sessionCount = this.sessions.size();
            Stats.setOpenConnections(this.sessionCount);
        }
    }

    public HTTPBandwidthMonitor getBandwidthMonitor() {
        return this.bandwidthMonitor;
    }

    public HentaiAtHomeClient getHentaiAtHomeClient() {
        return this.client;
    }

    private class FloodControlEntry {
        private InetAddress addr;
        private int connectCount;
        private long lastConnect;
        private long blocktime;

        public FloodControlEntry(InetAddress inetAddress) {
            this.addr = inetAddress;
            this.connectCount = 0;
            this.lastConnect = 0L;
            this.blocktime = 0L;
        }

        public boolean isStale() {
            return this.lastConnect < System.currentTimeMillis() - 60000L;
        }

        public boolean isBlocked() {
            return this.blocktime > System.currentTimeMillis();
        }

        public boolean hit() {
            long l = System.currentTimeMillis();
            this.connectCount = Math.max(0, this.connectCount - (int)Math.floor((l - this.lastConnect) / 1000L)) + 1;
            this.lastConnect = l;
            if (this.connectCount > 10) {
                this.blocktime = l + 60000L;
                return false;
            }
            return true;
        }
    }
}

