/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HTTPBandwidthMonitor;
import hath.base.HTTPResponse;
import hath.base.HTTPResponseProcessor;
import hath.base.HTTPServer;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;

public class HTTPSession
implements Runnable {
    public static final String CRLF = "\r\n";
    private static final Pattern getheadPattern = Pattern.compile("^((GET)|(HEAD)).*", 34);
    private SSLSocket socket;
    private HTTPServer httpServer;
    private int connId;
    private Thread myThread;
    private boolean localNetworkAccess;
    private long sessionStartTime = System.currentTimeMillis();
    private long lastPacketSend;
    private HTTPResponse hr;

    public HTTPSession(SSLSocket sSLSocket, int n, boolean bl, HTTPServer hTTPServer) {
        this.socket = sSLSocket;
        this.connId = n;
        this.localNetworkAccess = bl;
        this.httpServer = hTTPServer;
    }

    public void handleSession() {
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    private void connectionFinished() {
        if (this.hr != null) {
            this.hr.requestCompleted();
        }
        this.httpServer.removeHTTPSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader bufferedReader = null;
        FilterOutputStream filterOutputStream = null;
        HTTPResponseProcessor hTTPResponseProcessor = null;
        String string = this.toString() + " ";
        try {
            HTTPBandwidthMonitor hTTPBandwidthMonitor;
            String string2;
            this.socket.setSoTimeout(10000);
            bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            filterOutputStream = new DataOutputStream(this.socket.getOutputStream());
            String string3 = null;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                n += string2.length();
                if (getheadPattern.matcher(string2).matches()) {
                    string3 = string2.substring(0, Math.min(1000, string2.length()));
                    continue;
                }
                if (!string2.isEmpty()) continue;
                break;
            }
            this.hr = new HTTPResponse(this);
            this.hr.parseRequest(string3, this.localNetworkAccess);
            hTTPResponseProcessor = this.hr.getHTTPResponseProcessor();
            int n2 = this.hr.getResponseStatusCode();
            int n3 = hTTPResponseProcessor.getContentLength();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            StringBuilder stringBuilder = new StringBuilder(300);
            stringBuilder.append(this.getHTTPStatusHeader(n2));
            stringBuilder.append(hTTPResponseProcessor.getHeader());
            stringBuilder.append("Date: " + simpleDateFormat.format(new Date()) + " GMT" + CRLF);
            stringBuilder.append("Server: Genetic Lifeform and Distributed Open Server 1.6.1\r\n");
            stringBuilder.append("Connection: close\r\n");
            stringBuilder.append("Content-Type: " + hTTPResponseProcessor.getContentType() + CRLF);
            if (n3 > 0) {
                stringBuilder.append("Cache-Control: public, max-age=31536000\r\n");
                stringBuilder.append("Content-Length: " + n3 + CRLF);
            }
            stringBuilder.append(CRLF);
            byte[] byArray = stringBuilder.toString().getBytes(Charset.forName("ISO-8859-1"));
            if (string3 != null && n3 > 0) {
                try {
                    int n4 = (int)Math.min((long)(n3 + byArray.length + 32), Math.min(Settings.isUseLessMemory() ? 131072L : 524288L, Math.round(0.2 * (double)Settings.getThrottleBytesPerSec())));
                    this.socket.setSendBufferSize(n4);
                }
                catch (Exception exception) {
                    Out.info(exception.getMessage());
                }
            }
            if ((hTTPBandwidthMonitor = this.httpServer.getBandwidthMonitor()) != null && !this.localNetworkAccess) {
                hTTPBandwidthMonitor.waitForQuota(this.myThread, byArray.length);
            }
            ((DataOutputStream)filterOutputStream).write(byArray, 0, byArray.length);
            if (!this.localNetworkAccess) {
                Stats.bytesSent(byArray.length);
            }
            if (this.hr.isRequestHeadOnly()) {
                ((DataOutputStream)filterOutputStream).flush();
                string = string + "Code=" + n2 + " ";
                Out.info(string + (string3 == null ? "Invalid Request" : string3));
            } else {
                Object object;
                string = string + "Code=" + n2 + " Bytes=" + String.format("%1$-8s", n3) + " ";
                if (string3 != null) {
                    Out.info(string + string3);
                }
                long l = System.currentTimeMillis();
                if (n3 > 0) {
                    int n5 = 0;
                    object = new byte[1460];
                    for (int i = 0; i < n3; i += n5) {
                        this.lastPacketSend = System.currentTimeMillis();
                        ByteBuffer byteBuffer = hTTPResponseProcessor.getPreparedTCPBuffer();
                        n5 = byteBuffer.remaining();
                        if (hTTPBandwidthMonitor != null && !this.localNetworkAccess) {
                            hTTPBandwidthMonitor.waitForQuota(this.myThread, n5);
                        }
                        byteBuffer.get((byte[])object, 0, n5);
                        ((DataOutputStream)filterOutputStream).write((byte[])object, 0, n5);
                        if (this.localNetworkAccess) continue;
                        Stats.bytesSent(n5);
                    }
                }
                ((DataOutputStream)filterOutputStream).flush();
                long l2 = System.currentTimeMillis() - l;
                object = new DecimalFormat("0.00");
                Out.info(string + "Finished processing request in " + ((NumberFormat)object).format((double)l2 / 1000.0) + " seconds" + (l2 >= 10L ? " (" + ((NumberFormat)object).format((float)n3 / (float)l2) + " KB/s)" : ""));
            }
        }
        catch (Exception exception) {
            Out.debug(string + "The connection was interrupted or closed by the remote host.");
            Out.debug(exception == null ? "(no exception)" : exception.getMessage());
        }
        finally {
            if (hTTPResponseProcessor != null) {
                hTTPResponseProcessor.cleanup();
            }
            try {
                bufferedReader.close();
                filterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        this.connectionFinished();
    }

    private String getHTTPStatusHeader(int n) {
        switch (n) {
            case 200: {
                return "HTTP/1.1 200 OK\r\n";
            }
            case 301: {
                return "HTTP/1.1 301 Moved Permanently\r\n";
            }
            case 400: {
                return "HTTP/1.1 400 Bad Request\r\n";
            }
            case 403: {
                return "HTTP/1.1 403 Permission Denied\r\n";
            }
            case 404: {
                return "HTTP/1.1 404 Not Found\r\n";
            }
            case 405: {
                return "HTTP/1.1 405 Method Not Allowed\r\n";
            }
            case 418: {
                return "HTTP/1.1 418 I'm a teapot\r\n";
            }
            case 501: {
                return "HTTP/1.1 501 Not Implemented\r\n";
            }
            case 502: {
                return "HTTP/1.1 502 Bad Gateway\r\n";
            }
        }
        return "HTTP/1.1 500 Internal Server Error\r\n";
    }

    public boolean doTimeoutCheck() {
        int n;
        long l = System.currentTimeMillis();
        if (this.lastPacketSend < l - 1000L && this.socket.isClosed()) {
            return true;
        }
        int n2 = this.hr != null ? (this.hr.isServercmd() ? 1800000 : 180000) : (n = 30000);
        return this.sessionStartTime > 0L && this.sessionStartTime < l - (long)n || this.lastPacketSend > 0L && this.lastPacketSend < l - 30000L;
    }

    public void forceCloseSocket() {
        try {
            if (!this.socket.isClosed()) {
                Out.debug("Closing socket for session " + this.connId);
                this.socket.close();
                Out.debug("Closed socket for session " + this.connId);
            }
        }
        catch (Exception exception) {
            Out.debug(exception.toString());
        }
    }

    public HTTPServer getHTTPServer() {
        return this.httpServer;
    }

    public InetAddress getSocketInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean isLocalNetworkAccess() {
        return this.localNetworkAccess;
    }

    public String toString() {
        return "{" + this.connId + String.format("%1$-17s", this.getSocketInetAddress().toString() + "}");
    }
}

