/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.FileValidator;
import hath.base.Out;
import hath.base.Settings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class HVFile {
    private String hash;
    private int size;
    private int xres;
    private int yres;
    private String type;

    private HVFile(String string, int n, int n2, int n3, String string2) {
        this.hash = string;
        this.size = n;
        this.xres = n2;
        this.yres = n3;
        this.type = string2;
    }

    public File getLocalFileRef() {
        return new File(Settings.getCacheDir(), this.hash.substring(0, 2) + "/" + this.hash.substring(2, 4) + "/" + this.getFileid());
    }

    public Path getLocalFilePath() {
        return this.getLocalFileRef().toPath();
    }

    public String getMimeType() {
        if (this.type.equals("jpg")) {
            return "image/jpeg";
        }
        if (this.type.equals("png")) {
            return "image/png";
        }
        if (this.type.equals("gif")) {
            return "image/gif";
        }
        if (this.type.equals("wbm")) {
            return "video/webm";
        }
        return "application/octet-stream";
    }

    public String getFileid() {
        return this.hash + "-" + this.size + "-" + this.xres + "-" + this.yres + "-" + this.type;
    }

    public String getHash() {
        return this.hash;
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getStaticRange() {
        return this.hash.substring(0, 4);
    }

    public static boolean isValidHVFileid(String string) {
        return Pattern.matches("^[a-f0-9]{40}-[0-9]{1,8}-[0-9]{1,5}-[0-9]{1,5}-((jpg)|(png)|(gif)|(wbm))$", string);
    }

    public static HVFile getHVFileFromFile(File file) {
        return HVFile.getHVFileFromFile(file, null);
    }

    public static HVFile getHVFileFromFile(File file, FileValidator fileValidator) {
        if (file.exists()) {
            String string = file.getName();
            try {
                HVFile hVFile = HVFile.getHVFileFromFileid(string);
                if (hVFile == null) {
                    return null;
                }
                if (file.length() != (long)hVFile.getSize()) {
                    return null;
                }
                if (fileValidator != null && !fileValidator.validateFile(file.toPath(), string.substring(0, 40))) {
                    return null;
                }
                return hVFile;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Out.warning("Warning: Encountered IO error computing the hash value of " + file);
            }
        }
        return null;
    }

    public static HVFile getHVFileFromFileid(String string) {
        if (HVFile.isValidHVFileid(string)) {
            try {
                String[] stringArray = string.split("-");
                String string2 = stringArray[0];
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                int n3 = Integer.parseInt(stringArray[3]);
                String string3 = stringArray[4];
                return new HVFile(string2, n, n2, n3, string3);
            }
            catch (Exception exception) {
                Out.warning("Failed to parse fileid \"" + string + "\" : " + exception);
            }
        } else {
            Out.warning("Invalid fileid \"" + string + "\"");
        }
        return null;
    }

    public String toString() {
        return this.getFileid();
    }
}

