/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.CacheHandler;
import hath.base.ClientAPI;
import hath.base.GalleryDownloader;
import hath.base.HTTPServer;
import hath.base.InputQueryHandler;
import hath.base.InputQueryHandlerCLI;
import hath.base.Out;
import hath.base.ServerHandler;
import hath.base.Settings;
import hath.base.Stats;
import java.io.IOException;

public class HentaiAtHomeClient
implements Runnable {
    private InputQueryHandler iqh;
    private Out out;
    private boolean shutdown;
    private boolean reportShutdown;
    private boolean fastShutdown;
    private boolean threadInterruptable;
    private boolean doCertRefresh;
    private HTTPServer httpServer;
    private ClientAPI clientAPI;
    private CacheHandler cacheHandler;
    private ServerHandler serverHandler;
    private Thread myThread;
    private GalleryDownloader galleryDownloader = null;
    private Runtime runtime;
    private int threadSkipCounter;
    private long suspendedUntil;
    private String[] args;

    public HentaiAtHomeClient(InputQueryHandler inputQueryHandler, String[] stringArray) {
        this.iqh = inputQueryHandler;
        this.args = stringArray;
        this.shutdown = false;
        this.reportShutdown = false;
        this.threadInterruptable = false;
        this.runtime = Runtime.getRuntime();
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    @Override
    public void run() {
        this.out = new Out();
        System.setProperty("http.keepAlive", "false");
        Settings.setActiveClient(this);
        Settings.parseArgs(this.args);
        try {
            Settings.initializeDirectories();
        }
        catch (IOException iOException) {
            Out.error("Could not create program directories. Check file access permissions and free disk space.");
            System.exit(-1);
        }
        Out.startLoggers();
        Out.info("Hentai@Home 1.6.1 (Build 154) starting up\n");
        Out.info("Copyright (c) 2008-2020, E-Hentai.org - all rights reserved.");
        Out.info("This software comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to modify and redistribute it under the GPL v3 license.\n");
        Stats.resetStats();
        Stats.setProgramStatus("Logging in to main server...");
        this.clientAPI = new ClientAPI(this);
        Settings.loadClientLoginFromFile();
        if (!Settings.loginCredentialsAreSyntaxValid()) {
            Settings.promptForIDAndKey(this.iqh);
        }
        this.serverHandler = new ServerHandler(this);
        this.serverHandler.loadClientSettingsFromServer();
        Stats.setProgramStatus("Initializing cache handler...");
        try {
            this.cacheHandler = new CacheHandler(this);
        }
        catch (IOException iOException) {
            this.setFastShutdown();
            HentaiAtHomeClient.dieWithError(iOException);
            return;
        }
        if (this.isShuttingDown()) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        Stats.setProgramStatus("Starting HTTP server...");
        this.httpServer = new HTTPServer(this);
        if (!this.httpServer.startConnectionListener(Settings.getClientPort())) {
            this.setFastShutdown();
            HentaiAtHomeClient.dieWithError("Failed to initialize HTTPServer");
            return;
        }
        Stats.setProgramStatus("Sending startup notification...");
        Out.info("Notifying the server that we have finished starting up the client...");
        if (!this.serverHandler.notifyStart()) {
            this.setFastShutdown();
            Out.info("Startup notification failed.");
            return;
        }
        this.httpServer.allowNormalConnections();
        this.reportShutdown = true;
        if (Settings.isWarnNewClient()) {
            String string = "A new client version is available. Please download it from http://hentaiathome.net/ at your convenience.";
            Out.warning(string);
            if (Settings.getActiveGUI() != null) {
                Settings.getActiveGUI().notifyWarning("New Version Available", string);
            }
        }
        if (this.cacheHandler.getCacheCount() < 1) {
            Out.info("Important: Your cache does not yet contain any files. You won't see any traffic until the client has downloaded some.");
            Out.info("For a brand new client, it can take several hours before you start seeing any real traffic.");
        }
        this.serverHandler.refreshServerSettings();
        Stats.resetBytesSentHistory();
        Stats.programStarted();
        this.cacheHandler.processBlacklist(259200L);
        this.suspendedUntil = 0L;
        this.threadSkipCounter = 1;
        long l = 0L;
        System.gc();
        Out.info("H@H initialization completed successfully. Starting normal operation");
        while (!this.shutdown) {
            this.threadInterruptable = true;
            try {
                Thread.sleep(Math.max(1000L, 10000L - l));
            }
            catch (InterruptedException interruptedException) {
                Out.debug("Master thread sleep interrupted");
            }
            this.threadInterruptable = false;
            long l2 = System.currentTimeMillis();
            if (!this.shutdown && this.suspendedUntil < System.currentTimeMillis()) {
                int n;
                Stats.setProgramStatus("Running");
                if (this.suspendedUntil > 0L) {
                    this.resumeMasterThread();
                }
                if (this.doCertRefresh) {
                    Out.info("Doing internal restart of HTTP server to refresh certs");
                    if (!this.serverHandler.notifySuspend()) {
                        Out.warning("Failed to contact server to suspend client traffic; will retry");
                    } else {
                        try {
                            Thread.sleep(5000L);
                            this.httpServerShutdown(true);
                            n = 0;
                            do {
                                Out.info("Waiting for HTTPServer thread to fully terminate..." + (n > 1 ? " (waited " + n * 5 + " seconds)" : ""));
                                Thread.sleep(5000L);
                            } while (!this.httpServer.isThreadTerminated() && ++n < 60);
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.httpServer = new HTTPServer(this);
                        if (!this.httpServer.startConnectionListener(Settings.getClientPort())) {
                            this.setFastShutdown();
                            HentaiAtHomeClient.dieWithError("Failed to reinitialize HTTPServer");
                            return;
                        }
                        this.httpServer.allowNormalConnections();
                        this.serverHandler.stillAliveTest(true);
                        this.doCertRefresh = false;
                        Out.info("Internal HTTP server was successfully restarted");
                    }
                } else if (this.threadSkipCounter % 11 == 0) {
                    this.serverHandler.stillAliveTest(false);
                }
                if (this.threadSkipCounter % 30 == 1) {
                    if (Math.abs(Settings.getServerTimeDelta()) > 86400) {
                        Out.warning("Your system time seems to be off by more than 24 hours. You should shut down the client and correct your system time to ensure correct operation.");
                    }
                    if (this.httpServer.isCertExpired()) {
                        HentaiAtHomeClient.dieWithError("Either the system clock is significantly wrong, or something has gone wrong with certificate renewal. Check your system clock and internet connection, then restart the client manually.");
                    }
                }
                if (this.threadSkipCounter % 6 == 2) {
                    this.httpServer.pruneFloodControlTable();
                }
                if (this.threadSkipCounter % 1440 == 1439) {
                    Settings.clearRPCServerFailure();
                }
                if (this.threadSkipCounter % 2160 == 2159) {
                    this.cacheHandler.processBlacklist(43200L);
                }
                this.cacheHandler.cycleLRUCacheTable();
                this.httpServer.nukeOldConnections();
                Stats.shiftBytesSentHistory();
                for (n = 0; n < this.cacheHandler.getPruneAggression(); ++n) {
                    if (this.cacheHandler.recheckFreeDiskSpace()) continue;
                    HentaiAtHomeClient.dieWithError("The free disk space has dropped below the minimum allowed threshold. H@H cannot safely continue.\nFree up space for H@H, or reduce the cache size from the H@H settings page:\nhttps://e-hentai.org/hentaiathome.php?cid=" + Settings.getClientID());
                }
                System.gc();
                Out.debug("Memory total=" + this.runtime.totalMemory() / 1024L + "kB free=" + this.runtime.freeMemory() / 1024L + "kB max=" + this.runtime.maxMemory() / 1024L + "kB");
                ++this.threadSkipCounter;
            }
            l = System.currentTimeMillis() - l2;
        }
    }

    public void setCertRefresh() {
        this.doCertRefresh = true;
    }

    public boolean isSuspended() {
        return this.suspendedUntil > System.currentTimeMillis();
    }

    public boolean suspendMasterThread(int n) {
        if (n > 0 && n <= 86400 && this.suspendedUntil < System.currentTimeMillis()) {
            Stats.programSuspended();
            long l = n * 1000;
            this.suspendedUntil = System.currentTimeMillis() + l;
            Out.debug("Master thread suppressed for " + l / 1000L + " seconds.");
            return this.serverHandler.notifySuspend();
        }
        return false;
    }

    public boolean resumeMasterThread() {
        this.suspendedUntil = 0L;
        this.threadSkipCounter = 0;
        Stats.programResumed();
        return this.serverHandler.notifyResume();
    }

    public synchronized void startDownloader() {
        if (this.galleryDownloader == null) {
            this.galleryDownloader = new GalleryDownloader(this);
        }
    }

    public void deleteDownloader() {
        this.galleryDownloader = null;
    }

    public InputQueryHandler getInputQueryHandler() {
        return this.iqh;
    }

    public HTTPServer getHTTPServer() {
        return this.httpServer;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public ClientAPI getClientAPI() {
        return this.clientAPI;
    }

    public static void dieWithError(Exception exception) {
        exception.printStackTrace();
        HentaiAtHomeClient.dieWithError(exception.toString());
    }

    public static void dieWithError(String string) {
        Out.error("Critical Error: " + string);
        Stats.setProgramStatus("Died");
        Settings.getActiveClient().shutdown(false, string);
    }

    public void setFastShutdown() {
        Out.flushLogs();
        this.fastShutdown = true;
    }

    public void shutdown() {
        this.shutdown(false, null);
    }

    private void shutdown(String string) {
        this.shutdown(false, string);
    }

    private void shutdown(boolean bl, String string) {
        Out.flushLogs();
        if (!this.shutdown) {
            this.shutdown = true;
            Out.info("Shutting down...");
            if (this.reportShutdown) {
                if (this.serverHandler != null) {
                    this.serverHandler.notifyShutdown();
                }
                if (!this.fastShutdown && this.httpServer != null) {
                    Out.info("Shutdown in progress - please wait up to 30 seconds");
                    this.httpServerShutdown(false);
                }
            }
            if (this.threadInterruptable) {
                this.myThread.interrupt();
            }
            if (Math.random() > 0.99) {
                Out.info("                             .,---.\n                           ,/XM#MMMX;,\n                         -%##########M%,\n                        -@######%  $###@=\n         .,--,         -H#######$   $###M:\n      ,;$M###MMX;     .;##########$;HM###X=\n    ,/@##########H=      ;################+\n   -+#############M/,      %##############+\n   %M###############=      /##############:\n   H################      .M#############;.\n   @###############M      ,@###########M:.\n   X################,      -$=X#######@:\n   /@##################%-     +######$-\n   .;##################X     .X#####+,\n    .;H################/     -X####+.\n      ,;X##############,       .MM/\n         ,:+$H@M#######M#$-    .$$=\n              .,-=;+$@###X:    ;/=.\n                     .,/X$;   .::,\n                         .,    ..    \n");
            } else {
                String[] stringArray = new String[]{"I don't hate you", "Whyyyyyyyy...", "No hard feelings", "Your business is appreciated", "Good-night"};
                Out.info(stringArray[(int)Math.floor(Math.random() * (double)stringArray.length)]);
            }
            if (this.cacheHandler != null) {
                this.cacheHandler.terminateCache();
            }
            if (string != null && Settings.getActiveGUI() != null) {
                Settings.getActiveGUI().notifyError(string);
            }
            Out.disableLogging();
        }
        if (!bl) {
            System.exit(0);
        }
    }

    private void httpServerShutdown(boolean bl) {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.httpServer.stopConnectionListener(bl);
        int n = 0;
        int n2 = 25;
        while (++n < n2 && Stats.getOpenConnections() > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n % 5 != 0) continue;
            Out.info("Waiting for " + Stats.getOpenConnections() + " request(s) to finish; will wait for another " + (n2 - n) + " seconds");
        }
    }

    public boolean isShuttingDown() {
        return this.shutdown;
    }

    public static void main(String[] stringArray) {
        InputQueryHandlerCLI inputQueryHandlerCLI = null;
        try {
            inputQueryHandlerCLI = InputQueryHandlerCLI.getIQHCLI();
            new HentaiAtHomeClient(inputQueryHandlerCLI, stringArray);
        }
        catch (Exception exception) {
            Out.error("Failed to initialize InputQueryHandler");
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            HentaiAtHomeClient.this.shutdown(true, null);
        }
    }
}

