/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HVFile;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.Settings;
import hath.base.Stats;
import hath.base.Tools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Arrays;

public class ProxyFileDownloader
implements Runnable {
    private HentaiAtHomeClient client;
    private HVFile requestedHVFile;
    private String fileid;
    private File tempFile = null;
    private File returnFile = null;
    private RandomAccessFile fileHandle;
    private FileChannel fileChannel;
    private URL[] sources;
    private URLConnection connection;
    private Thread myThread;
    private MessageDigest sha1Digest;
    private int readoff;
    private int writeoff;
    private int contentLength;
    private boolean streamThreadSuccess = false;
    private boolean streamThreadComplete = false;
    private boolean proxyThreadComplete = false;
    private boolean fileFinalized = false;
    private Object downloadLock = new Object();

    public ProxyFileDownloader(HentaiAtHomeClient hentaiAtHomeClient, String string, URL[] uRLArray) {
        this.client = hentaiAtHomeClient;
        this.fileid = string;
        this.sources = uRLArray;
        this.requestedHVFile = HVFile.getHVFileFromFileid(string);
        this.writeoff = 0;
        this.readoff = 0;
        this.myThread = new Thread(this);
    }

    public int initialize() {
        Out.debug("ProxyFileDownloader::initialize with fileid=" + this.fileid + " sources=" + Arrays.toString(this.sources));
        int n = 500;
        for (URL uRL : this.sources) {
            try {
                Out.debug("ProxyFileDownloader: Requesting file download from " + uRL);
                this.connection = uRL.openConnection();
                this.connection.setConnectTimeout(5000);
                this.connection.setReadTimeout(30000);
                this.connection.setRequestProperty("Hath-Request", Settings.getClientID() + "-" + Tools.getSHA1String(Settings.getClientKey() + this.fileid));
                this.connection.setRequestProperty("User-Agent", "Hentai@Home 1.6.1");
                this.connection.connect();
                int n2 = this.connection.getContentLength();
                n = 0;
                if (n2 < 0) {
                    Out.warning("Request host did not send Content-Length, aborting transfer. (" + this.connection + ")");
                    Out.warning("Note: A common reason for this is running firewalls with outgoing restrictions or programs like PeerGuardian/PeerBlock. Verify that the remote host is not blocked.");
                    n = 502;
                } else if (n2 > Settings.getMaxAllowedFileSize()) {
                    Out.warning("Reported contentLength " + this.contentLength + " exceeds currently max allowed filesize " + Settings.getMaxAllowedFileSize());
                    n = 502;
                } else if (n2 != this.requestedHVFile.getSize()) {
                    Out.warning("Reported contentLength " + this.contentLength + " does not match expected length of file " + this.fileid + " (" + this.connection + ")");
                    n = 502;
                }
                if (n > 0) continue;
                this.contentLength = n2;
                this.tempFile = File.createTempFile("proxyfile_", "", Settings.getTempDir());
                this.fileHandle = new RandomAccessFile(this.tempFile, "rw");
                this.fileChannel = this.fileHandle.getChannel();
                this.sha1Digest = MessageDigest.getInstance("SHA-1");
                this.myThread.start();
                n = 200;
                break;
            }
            catch (Exception exception) {
                Out.warning(exception.getMessage());
                try {
                    if (this.fileHandle == null) continue;
                    this.fileHandle.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.downloadLock;
        synchronized (object) {
            int n = 3;
            int n2 = 65536;
            int n3 = (int)Math.floor((double)n2 * 0.75);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(Math.min(this.contentLength, n2));
            do {
                InputStream inputStream = null;
                Channel channel = null;
                try {
                    inputStream = this.connection.getInputStream();
                    channel = Channels.newChannel(inputStream);
                    long l = System.currentTimeMillis();
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    while (this.writeoff < this.contentLength) {
                        if (inputStream.available() > 0) {
                            n6 = 0;
                            n4 = channel.read(byteBuffer);
                            if (n4 >= 0) {
                                this.readoff += n4;
                                if (this.readoff != this.contentLength && (this.readoff <= this.writeoff + n3 || this.writeoff >= this.contentLength - n2)) continue;
                                byteBuffer.flip();
                                this.sha1Digest.update(byteBuffer.asReadOnlyBuffer());
                                n5 = this.fileChannel.write(byteBuffer, this.writeoff);
                                this.writeoff += n5;
                                Stats.bytesRcvd(n5);
                                byteBuffer.clear();
                                continue;
                            }
                            Out.warning("\nServer sent premature EOF, aborting.. (" + this.writeoff + " of " + this.contentLength + " bytes received)");
                            throw new SocketException("Unexpected end of file from server");
                        }
                        if (System.currentTimeMillis() - l > 300000L) {
                            Out.warning("\nDownload time limit has expired, aborting...");
                            throw new SocketTimeoutException("Download timed out");
                        }
                        if (n6 > 30000) {
                            Out.warning("\nTimeout detected waiting for byte " + this.writeoff + ", aborting..");
                            throw new SocketTimeoutException("Read timed out");
                        }
                        n6 += 5;
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    Stats.fileRcvd();
                    this.streamThreadSuccess = true;
                }
                catch (Exception exception) {
                    this.writeoff = 0;
                    this.readoff = 0;
                    byteBuffer.clear();
                    this.sha1Digest.reset();
                    Out.debug("Retrying.. (" + n + " tries left)");
                }
                finally {
                    try {
                        channel.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            } while (!this.streamThreadSuccess && --n > 0);
            this.streamThreadComplete = true;
            this.checkFinalizeDownloadedFile();
        }
    }

    public String getContentType() {
        return this.requestedHVFile.getMimeType();
    }

    public int getContentLength() {
        return this.requestedHVFile.getSize();
    }

    public int getCurrentWriteoff() {
        return this.writeoff;
    }

    public int fillBuffer(ByteBuffer byteBuffer, int n) throws IOException {
        int n2 = 0;
        while (byteBuffer.hasRemaining() && this.writeoff > n + n2) {
            n2 += this.fileChannel.read(byteBuffer, n + n2);
        }
        return n2;
    }

    public void proxyThreadCompleted() {
        Stats.fileSent();
        this.proxyThreadComplete = true;
        this.checkFinalizeDownloadedFile();
    }

    private synchronized void checkFinalizeDownloadedFile() {
        if (!this.streamThreadComplete || !this.proxyThreadComplete) {
            return;
        }
        if (this.fileFinalized) {
            Out.warning("ProxyFileDownloader: Attempted to finalize file that was already finalized");
            return;
        }
        this.fileFinalized = true;
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileHandle != null) {
            try {
                this.fileHandle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tempFile.length() != (long)this.getContentLength()) {
            Out.debug("Requested file " + this.fileid + " is incomplete, and will not be stored. (bytes=" + this.tempFile.length() + ")");
        } else {
            String string = Tools.binaryToHex(this.sha1Digest.digest());
            if (!this.requestedHVFile.getHash().equals(string)) {
                Out.debug("Requested file " + this.fileid + " is corrupt, and will not be stored. (digest=" + string + ")");
            } else if (!Settings.isStaticRange(this.fileid)) {
                Out.debug("The file " + this.fileid + " is not in a static range, and will not be stored.");
            } else {
                if (this.client.getCacheHandler().importFile(this.tempFile, this.requestedHVFile)) {
                    Out.debug("Requested file " + this.fileid + " was successfully stored in cache.");
                } else {
                    Out.debug("Requested file " + this.fileid + " exists or cannot be cached.");
                }
                Out.debug("Proxy file download request complete for " + this.fileid);
            }
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }
}

