/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.CakeSphere;
import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import hath.base.ServerResponse;
import hath.base.Settings;
import hath.base.Stats;
import hath.base.Tools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServerHandler {
    public static final String ACT_SERVER_STAT = "server_stat";
    public static final String ACT_GET_BLACKLIST = "get_blacklist";
    public static final String ACT_GET_CERTIFICATE = "get_cert";
    public static final String ACT_CLIENT_LOGIN = "client_login";
    public static final String ACT_CLIENT_SETTINGS = "client_settings";
    public static final String ACT_CLIENT_START = "client_start";
    public static final String ACT_CLIENT_SUSPEND = "client_suspend";
    public static final String ACT_CLIENT_RESUME = "client_resume";
    public static final String ACT_CLIENT_STOP = "client_stop";
    public static final String ACT_STILL_ALIVE = "still_alive";
    public static final String ACT_STATIC_RANGE_FETCH = "srfetch";
    public static final String ACT_DOWNLOADER_FETCH = "dlfetch";
    public static final String ACT_DOWNLOADER_FAILREPORT = "dlfails";
    public static final String ACT_OVERLOAD = "overload";
    private HentaiAtHomeClient client;
    private static boolean loginValidated = false;
    private long lastOverloadNotification;

    public ServerHandler(HentaiAtHomeClient hentaiAtHomeClient) {
        this.client = hentaiAtHomeClient;
        this.lastOverloadNotification = 0L;
    }

    public static URL getServerConnectionURL(String string) {
        return ServerHandler.getServerConnectionURL(string, "");
    }

    public static URL getServerConnectionURL(String string, String string2) {
        URL uRL = null;
        try {
            uRL = string.equals(ACT_SERVER_STAT) ? new URL("http://" + Settings.getRPCServerHost() + "/" + "15/rpc?" + "clientbuild=" + 154 + "&act=" + string) : new URL("http://" + Settings.getRPCServerHost() + "/" + "15/rpc?" + ServerHandler.getURLQueryString(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            HentaiAtHomeClient.dieWithError(malformedURLException);
        }
        return uRL;
    }

    public static String getURLQueryString(String string, String string2) {
        int n = Settings.getServerTime();
        String string3 = Tools.getSHA1String("hentai@home-" + string + "-" + string2 + "-" + Settings.getClientID() + "-" + n + "-" + Settings.getClientKey());
        return "clientbuild=154&act=" + string + "&add=" + string2 + "&cid=" + Settings.getClientID() + "&acttime=" + n + "&actkey=" + string3;
    }

    private boolean simpleNotification(String string, String string2) {
        ServerResponse serverResponse = ServerResponse.getServerResponse(string, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            Out.debug(string2 + " notification successful.");
            return true;
        }
        Out.warning(string2 + " notification failed.");
        return false;
    }

    public boolean notifySuspend() {
        return this.simpleNotification(ACT_CLIENT_SUSPEND, "Suspend");
    }

    public boolean notifyResume() {
        return this.simpleNotification(ACT_CLIENT_RESUME, "Resume");
    }

    public boolean notifyShutdown() {
        return this.simpleNotification(ACT_CLIENT_STOP, "Shutdown");
    }

    public boolean notifyOverload() {
        long l = System.currentTimeMillis();
        if (this.lastOverloadNotification < l - 30000L) {
            this.lastOverloadNotification = l;
            return this.simpleNotification(ACT_OVERLOAD, "Overload");
        }
        return false;
    }

    public boolean notifyStart() {
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_START, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            Out.info("Start notification successful. Note that there may be a short wait before the server registers this client on the network.");
            Stats.serverContact();
            return true;
        }
        String string = serverResponse.getFailCode();
        Out.warning("Startup Failure: " + string);
        Out.debug(serverResponse.toString());
        if (string.startsWith("FAIL_CONNECT_TEST")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The client has failed the external connection test.");
            Out.info("The server failed to verify that this client is online and available from the Internet.");
            Out.info("If you are behind a firewall, please check that port " + Settings.getClientPort() + " is forwarded to this computer.");
            Out.info("You might also want to check that " + Settings.getClientHost() + " is your actual public IP address.");
            Out.info("If you need assistance with forwarding a port to this client, locate a guide for your particular router at http://portforward.com/");
            Out.info("The client will remain running so you can run port connection tests.");
            Out.info("Use Program -> Exit in windowed mode or hit Ctrl+C in console mode to exit the program.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            return false;
        }
        if (string.startsWith("FAIL_OTHER_CLIENT_CONNECTED")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The server detected that another client was already connected from this computer or local network.");
            Out.info("You can only have one client running per public IP address.");
            Out.info("The program will now terminate.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            HentaiAtHomeClient.dieWithError("FAIL_OTHER_CLIENT_CONNECTED");
        } else if (string.startsWith("FAIL_CID_IN_USE")) {
            Out.info("");
            Out.info("************************************************************************************************************************************");
            Out.info("The server detected that another client is already using this client ident.");
            Out.info("If you want to run more than one client, you have to apply for additional idents.");
            Out.info("The program will now terminate.");
            Out.info("************************************************************************************************************************************");
            Out.info("");
            HentaiAtHomeClient.dieWithError("FAIL_CID_IN_USE");
        }
        return false;
    }

    public String[] getBlacklist(long l) {
        URL uRL = ServerHandler.getServerConnectionURL(ACT_GET_BLACKLIST, "" + l);
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            return serverResponse.getResponseText();
        }
        return null;
    }

    public void stillAliveTest(boolean bl) {
        CakeSphere cakeSphere = new CakeSphere(this, this.client);
        cakeSphere.stillAlive(bl);
    }

    public void loadClientSettingsFromServer() {
        Stats.setProgramStatus("Loading settings from server...");
        Out.info("Connecting to the Hentai@Home Server to register client with ID " + Settings.getClientID() + "...");
        try {
            do {
                if (!this.refreshServerStat()) {
                    HentaiAtHomeClient.dieWithError("Failed to get initial stat from server.");
                }
                Out.info("Reading Hentai@Home client settings from server...");
                ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_LOGIN, this);
                if (serverResponse.getResponseStatus() == 1) {
                    loginValidated = true;
                    Out.info("Applying settings...");
                    Settings.parseAndUpdateSettings(serverResponse.getResponseText());
                    Out.info("Finished applying settings");
                    continue;
                }
                if (serverResponse.getResponseStatus() == 0) {
                    HentaiAtHomeClient.dieWithError("Failed to get a login response from server.");
                    continue;
                }
                Out.warning("\nAuthentication failed, please re-enter your Client ID and Key (Code: " + serverResponse.getFailCode() + ")");
                Settings.promptForIDAndKey(this.client.getInputQueryHandler());
            } while (!loginValidated);
        }
        catch (Exception exception) {
            HentaiAtHomeClient.dieWithError(exception);
        }
    }

    public boolean refreshServerSettings() {
        Out.info("Refreshing Hentai@Home client settings from server...");
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_CLIENT_SETTINGS, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            Settings.parseAndUpdateSettings(serverResponse.getResponseText());
            Out.info("Finished applying settings");
            return true;
        }
        Out.warning("Failed to refresh settings");
        return false;
    }

    public boolean refreshServerStat() {
        Stats.setProgramStatus("Getting initial stats from server...");
        ServerResponse serverResponse = ServerResponse.getServerResponse(ACT_SERVER_STAT, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            Settings.parseAndUpdateSettings(serverResponse.getResponseText());
            return true;
        }
        return false;
    }

    public URL[] getStaticRangeFetchURL(String string, String string2, String string3) {
        URL uRL = ServerHandler.getServerConnectionURL(ACT_STATIC_RANGE_FETCH, string + ";" + string2 + ";" + string3);
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            String[] stringArray = serverResponse.getResponseText();
            try {
                List<URL> list = Collections.checkedList(new ArrayList(), URL.class);
                for (String string4 : stringArray) {
                    if (string4.equals("")) continue;
                    list.add(new URL(string4));
                }
                return list.isEmpty() ? null : list.toArray(new URL[list.size()]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Out.info("Failed to request static range download link for " + string3 + ".");
        return null;
    }

    public URL getDownloaderFetchURL(int n, int n2, int n3, String string, boolean bl) {
        URL uRL = ServerHandler.getServerConnectionURL(ACT_DOWNLOADER_FETCH, n + ";" + n2 + ";" + n3 + ";" + string + ";" + (bl ? 1 : 0));
        ServerResponse serverResponse = ServerResponse.getServerResponse(uRL, this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        if (serverResponse.getResponseStatus() == 1) {
            String[] stringArray = serverResponse.getResponseText();
            try {
                return new URL(stringArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Out.info("Failed to request gallery file url for fileindex=" + n3 + ".");
        return null;
    }

    public void reportDownloaderFailures(List<String> list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n < 1 || n > 50) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        int n2 = 0;
        for (String string : list) {
            stringBuilder.append(string);
            if (++n2 >= n) continue;
            stringBuilder.append(";");
        }
        ServerResponse serverResponse = ServerResponse.getServerResponse(ServerHandler.getServerConnectionURL(ACT_DOWNLOADER_FAILREPORT, stringBuilder.toString()), this);
        if (serverResponse.getResponseStatus() == 0) {
            Settings.markRPCServerFailure(serverResponse.getFailHost());
        }
        Out.debug("Reported " + n + " download failures with response " + (serverResponse.getResponseStatus() == 1 ? "OK" : "FAIL"));
    }

    public static boolean isLoginValidated() {
        return loginValidated;
    }
}

