/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HathGUI;
import hath.base.HentaiAtHomeClient;
import hath.base.InputQueryHandler;
import hath.base.Out;
import hath.base.Tools;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class Settings {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int CLIENT_BUILD = 154;
    public static final int CLIENT_KEY_LENGTH = 20;
    public static final int MAX_KEY_TIME_DRIFT = 300;
    public static final int MAX_CONNECTION_BASE = 20;
    public static final int TCP_PACKET_SIZE = 1460;
    public static final String CLIENT_VERSION = "1.6.1";
    public static final String CLIENT_RPC_PROTOCOL = "http://";
    public static final String CLIENT_RPC_HOST = "rpc.hentaiathome.net";
    public static final String CLIENT_RPC_FILE = "15/rpc?";
    public static final String CLIENT_LOGIN_FILENAME = "client_login";
    public static final String CONTENT_TYPE_DEFAULT = "text/html; charset=iso-8859-1";
    public static final String CONTENT_TYPE_OCTET = "application/octet-stream";
    public static final String CONTENT_TYPE_JPG = "image/jpeg";
    public static final String CONTENT_TYPE_PNG = "image/png";
    public static final String CONTENT_TYPE_GIF = "image/gif";
    public static final String CONTENT_TYPE_WEBM = "video/webm";
    private static HentaiAtHomeClient activeClient = null;
    private static HathGUI activeGUI = null;
    private static Object rpcServerLock = new Object();
    private static InetAddress[] rpcServers = null;
    private static String rpcServerCurrent = null;
    private static String rpcServerLastFailed = null;
    private static Hashtable<String, Integer> staticRanges = null;
    private static File datadir = null;
    private static File logdir = null;
    private static File cachedir = null;
    private static File tempdir = null;
    private static File downloaddir = null;
    private static String clientKey = "";
    private static String clientHost = "";
    private static String dataDirPath = "data";
    private static String logDirPath = "log";
    private static String cacheDirPath = "cache";
    private static String tempDirPath = "tmp";
    private static String downloadDirPath = "download";
    private static int clientID = 0;
    private static int clientPort = 0;
    private static int throttle_bytes = 0;
    private static int overrideConns = 0;
    private static int serverTimeDelta = 0;
    private static int maxAllowedFileSize = 0x6400000;
    private static int currentStaticRangeCount = 0;
    private static long disklimit_bytes = 0L;
    private static long diskremaining_bytes = 0L;
    private static long fileSystemBlocksize = 4096L;
    private static boolean verifyCache = false;
    private static boolean rescanCache = false;
    private static boolean skipFreeSpaceCheck = false;
    private static boolean warnNewClient = false;
    private static boolean useLessMemory = false;
    private static boolean disableBWM = false;
    private static boolean disableDownloadBWM = false;
    private static boolean disableLogs = false;
    private static boolean flushLogs = false;
    private static boolean disableIPOriginCheck = false;
    private static boolean disableFloodControl = false;

    public static void setActiveClient(HentaiAtHomeClient hentaiAtHomeClient) {
        activeClient = hentaiAtHomeClient;
    }

    public static void setActiveGUI(HathGUI hathGUI) {
        activeGUI = hathGUI;
    }

    public static boolean loginCredentialsAreSyntaxValid() {
        return clientID > 0 && Pattern.matches("^[a-zA-Z0-9]{20}$", clientKey);
    }

    public static boolean loadClientLoginFromFile() {
        File file = new File(Settings.getDataDir(), CLIENT_LOGIN_FILENAME);
        if (!file.exists()) {
            return false;
        }
        try {
            String[] stringArray;
            String string = Tools.getStringFileContents(file);
            if (!string.isEmpty() && (stringArray = string.split("-", 2)).length == 2) {
                clientID = Integer.parseInt(stringArray[0]);
                clientKey = stringArray[1];
                Out.info("Loaded login settings from client_login");
                return true;
            }
        }
        catch (Exception exception) {
            Out.warning("Encountered error when reading client_login: " + exception);
        }
        return false;
    }

    public static void promptForIDAndKey(InputQueryHandler inputQueryHandler) {
        Out.info("Before you can use this client, you will have to register it at http://hentaiathome.net/");
        Out.info("IMPORTANT: YOU NEED A SEPARATE IDENT FOR EACH CLIENT YOU WANT TO RUN.");
        Out.info("DO NOT ENTER AN IDENT THAT WAS ASSIGNED FOR A DIFFERENT CLIENT UNLESS IT HAS BEEN RETIRED.");
        Out.info("After registering, enter your ID and Key below to start your client.");
        Out.info("(You will only have to do this once.)\n");
        clientID = 0;
        clientKey = "";
        do {
            try {
                clientID = Integer.parseInt(inputQueryHandler.queryString("Enter Client ID").trim());
            }
            catch (NumberFormatException numberFormatException) {
                Out.warning("Invalid Client ID. Please try again.");
            }
        } while (clientID < 1000);
        do {
            clientKey = inputQueryHandler.queryString("Enter Client Key").trim();
            if (Settings.loginCredentialsAreSyntaxValid()) continue;
            Out.warning("Invalid Client Key, it must be exactly 20 alphanumerical characters. Please try again.");
        } while (!Settings.loginCredentialsAreSyntaxValid());
        try {
            Tools.putStringFileContents(new File(Settings.getDataDir(), CLIENT_LOGIN_FILENAME), clientID + "-" + clientKey);
        }
        catch (IOException iOException) {
            Out.warning("Error encountered when writing client_login: " + iOException);
        }
    }

    public static boolean parseAndUpdateSettings(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            String[] stringArray2;
            if (string == null || (stringArray2 = string.split("=", 2)).length != 2) continue;
            Settings.updateSetting(stringArray2[0].toLowerCase(), stringArray2[1]);
        }
        return true;
    }

    public static boolean parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            if (string.startsWith("--")) {
                String[] stringArray2 = string.substring(2).split("=", 2);
                if (stringArray2.length == 2) {
                    Settings.updateSetting(stringArray2[0].toLowerCase(), stringArray2[1]);
                    continue;
                }
                Settings.updateSetting(stringArray2[0].toLowerCase(), "true");
                continue;
            }
            Out.warning("Invalid command argument: " + string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSetting(String string, String string2) {
        string = string.replace("-", "_");
        try {
            if (string.equals("min_client_build")) {
                if (Integer.parseInt(string2) > 154) {
                    HentaiAtHomeClient.dieWithError("Your client is too old to connect to the Hentai@Home Network. Please download the new version of the client from http://hentaiathome.net/");
                }
            } else if (string.equals("cur_client_build")) {
                if (Integer.parseInt(string2) > 154) {
                    warnNewClient = true;
                }
            } else {
                if (string.equals("server_time")) {
                    serverTimeDelta = Integer.parseInt(string2) - (int)(System.currentTimeMillis() / 1000L);
                    Out.debug("Setting altered: serverTimeDelta=" + serverTimeDelta);
                    return true;
                }
                if (string.equals("rpc_server_ip")) {
                    Object object = rpcServerLock;
                    synchronized (object) {
                        String[] stringArray = string2.split(";");
                        rpcServers = new InetAddress[stringArray.length];
                        int n = 0;
                        for (String string3 : stringArray) {
                            Settings.rpcServers[n++] = InetAddress.getByName(string3);
                        }
                        rpcServerCurrent = null;
                    }
                } else if (string.equals("host")) {
                    clientHost = string2;
                } else if (string.equals("port")) {
                    if (clientPort == 0) {
                        clientPort = Integer.parseInt(string2);
                    }
                } else if (string.equals("throttle_bytes")) {
                    throttle_bytes = Integer.parseInt(string2);
                } else if (string.equals("disklimit_bytes")) {
                    long l = Long.parseLong(string2);
                    if (l >= disklimit_bytes) {
                        disklimit_bytes = l;
                    } else {
                        Out.warning("The disk limit has been reduced. However, this change will not take effect until you restart your client.");
                    }
                } else if (string.equals("diskremaining_bytes")) {
                    diskremaining_bytes = Long.parseLong(string2);
                } else if (string.equals("filesystem_blocksize")) {
                    fileSystemBlocksize = Long.parseLong(string2);
                    if (fileSystemBlocksize < 0L || fileSystemBlocksize > 65536L) {
                        Out.warning("A filesystem blocksize of " + fileSystemBlocksize + " bytes is not sane. Using the default of 4096 bytes.");
                        fileSystemBlocksize = 4096L;
                    }
                } else if (string.equals("rescan_cache")) {
                    rescanCache = string2.equals("true");
                } else if (string.equals("verify_cache")) {
                    verifyCache = string2.equals("true");
                    rescanCache = string2.equals("true");
                } else if (string.equals("use_less_memory")) {
                    useLessMemory = string2.equals("true");
                } else if (string.equals("disable_logging")) {
                    disableLogs = string2.equals("true");
                    Out.disableLogging();
                } else if (string.equals("disable_bwm")) {
                    disableBWM = string2.equals("true");
                    disableDownloadBWM = string2.equals("true");
                } else if (string.equals("disable_download_bwm")) {
                    disableDownloadBWM = string2.equals("true");
                } else if (string.equals("disable_ip_origin_check")) {
                    disableIPOriginCheck = string2.equals("true");
                } else if (string.equals("disable_flood_control")) {
                    disableFloodControl = string2.equals("true");
                } else if (string.equals("skip_free_space_check")) {
                    skipFreeSpaceCheck = string2.equals("true");
                } else if (string.equals("max_connections")) {
                    overrideConns = Integer.parseInt(string2);
                } else if (string.equals("max_allowed_filesize")) {
                    maxAllowedFileSize = Integer.parseInt(string2);
                } else if (string.equals("static_ranges")) {
                    staticRanges = new Hashtable((int)((double)string2.length() * 0.3));
                    currentStaticRangeCount = 0;
                    for (String string4 : string2.split(";")) {
                        if (string4.length() != 4) continue;
                        ++currentStaticRangeCount;
                        staticRanges.put(string4, 1);
                    }
                } else if (string.equals("cache_dir")) {
                    cacheDirPath = string2;
                } else if (string.equals("temp_dir")) {
                    tempDirPath = string2;
                } else if (string.equals("data_dir")) {
                    dataDirPath = string2;
                } else if (string.equals("log_dir")) {
                    logDirPath = string2;
                } else if (string.equals("download_dir")) {
                    downloadDirPath = string2;
                } else if (string.equals("flush_logs")) {
                    flushLogs = string2.equals("true");
                } else if (!string.equals("silentstart")) {
                    Out.warning("Unknown setting " + string + " = " + string2);
                    return false;
                }
            }
            Out.debug("Setting altered: " + string + "=" + string2);
            return true;
        }
        catch (Exception exception) {
            Out.warning("Failed parsing setting " + string + " = " + string2);
            return false;
        }
    }

    public static void initializeDirectories() throws IOException {
        Out.debug("Using --data-dir=" + dataDirPath);
        datadir = Tools.checkAndCreateDir(new File(dataDirPath));
        Out.debug("Using --log-dir=" + logDirPath);
        logdir = Tools.checkAndCreateDir(new File(logDirPath));
        Out.debug("Using --cache-dir=" + cacheDirPath);
        cachedir = Tools.checkAndCreateDir(new File(cacheDirPath));
        Out.debug("Using --temp-dir=" + tempDirPath);
        tempdir = Tools.checkAndCreateDir(new File(tempDirPath));
        Out.debug("Using --download-dir=" + downloadDirPath);
        downloaddir = Tools.checkAndCreateDir(new File(downloadDirPath));
    }

    public static File getDataDir() {
        return datadir;
    }

    public static File getLogDir() {
        return logdir;
    }

    public static File getCacheDir() {
        return cachedir;
    }

    public static File getTempDir() {
        return tempdir;
    }

    public static File getDownloadDir() {
        return downloaddir;
    }

    public static int getClientID() {
        return clientID;
    }

    public static String getClientKey() {
        return clientKey;
    }

    public static String getClientHost() {
        return clientHost;
    }

    public static int getClientPort() {
        return clientPort;
    }

    public static int getThrottleBytesPerSec() {
        return throttle_bytes;
    }

    public static int getMaxAllowedFileSize() {
        return maxAllowedFileSize;
    }

    public static long getDiskLimitBytes() {
        return disklimit_bytes;
    }

    public static long getDiskMinRemainingBytes() {
        return diskremaining_bytes;
    }

    public static long getFileSystemBlockSize() {
        return fileSystemBlocksize;
    }

    public static int getServerTime() {
        return (int)(System.currentTimeMillis() / 1000L) + serverTimeDelta;
    }

    public static int getServerTimeDelta() {
        return serverTimeDelta;
    }

    public static String getOutputLogPath() {
        return Settings.getLogDir().getPath() + "/log_out";
    }

    public static String getErrorLogPath() {
        return Settings.getLogDir().getPath() + "/log_err";
    }

    public static boolean isFlushLogs() {
        return flushLogs;
    }

    public static boolean isRescanCache() {
        return rescanCache;
    }

    public static boolean isVerifyCache() {
        return verifyCache;
    }

    public static boolean isUseLessMemory() {
        return useLessMemory;
    }

    public static boolean isSkipFreeSpaceCheck() {
        return skipFreeSpaceCheck;
    }

    public static boolean isWarnNewClient() {
        return warnNewClient;
    }

    public static boolean isDisableBWM() {
        return disableBWM;
    }

    public static boolean isDisableDownloadBWM() {
        return disableDownloadBWM;
    }

    public static boolean isDisableLogs() {
        return disableLogs;
    }

    public static boolean isDisableIPOriginCheck() {
        return disableIPOriginCheck;
    }

    public static boolean isDisableFloodControl() {
        return disableFloodControl;
    }

    public static HentaiAtHomeClient getActiveClient() {
        return activeClient;
    }

    public static HathGUI getActiveGUI() {
        return activeGUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidRPCServer(InetAddress inetAddress) {
        if (disableIPOriginCheck) {
            return true;
        }
        Object object = rpcServerLock;
        synchronized (object) {
            if (rpcServers == null) {
                return false;
            }
            for (InetAddress inetAddress2 : rpcServers) {
                if (!inetAddress2.equals(inetAddress)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRPCServerHost() {
        Object object = rpcServerLock;
        synchronized (object) {
            if (rpcServerCurrent == null) {
                if (rpcServers == null) {
                    return CLIENT_RPC_HOST;
                }
                if (rpcServers.length < 1) {
                    return CLIENT_RPC_HOST;
                }
                if (rpcServers.length == 1) {
                    rpcServerCurrent = rpcServers[0].getHostAddress().toLowerCase();
                } else {
                    String string;
                    int n = (int)(Math.random() * (double)rpcServers.length);
                    int n2 = Math.random() < 0.5 ? -1 : 1;
                    while (true) {
                        string = rpcServers[(rpcServers.length + n) % rpcServers.length].getHostAddress().toLowerCase();
                        if (rpcServerLastFailed == null || !string.equals(rpcServerLastFailed)) break;
                        Out.debug(rpcServerLastFailed + " was marked as last failed");
                        n += n2;
                    }
                    rpcServerCurrent = string;
                    Out.debug("Selected rpcServerCurrent=" + rpcServerCurrent);
                }
            }
            return rpcServerCurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRPCServerFailure() {
        Object object = rpcServerLock;
        synchronized (object) {
            if (rpcServerLastFailed != null) {
                Out.debug("Cleared rpcServerLastFailed");
                rpcServerLastFailed = null;
                rpcServerCurrent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markRPCServerFailure(String string) {
        Object object = rpcServerLock;
        synchronized (object) {
            if (rpcServerCurrent != null) {
                Out.debug("Marking " + string + " as rpcServerLastFailed");
                rpcServerLastFailed = string;
                rpcServerCurrent = null;
            }
        }
    }

    public static int getMaxConnections() {
        if (overrideConns > 0) {
            return overrideConns;
        }
        return 20 + Math.min(480, throttle_bytes / 10000);
    }

    public static boolean isStaticRange(String string) {
        if (staticRanges != null) {
            return staticRanges.containsKey(string.substring(0, 4));
        }
        return false;
    }

    public static int getStaticRangeCount() {
        return currentStaticRangeCount;
    }
}

