/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HentaiAtHomeClient;
import hath.base.Settings;
import hath.base.StatListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Stats {
    private static List<StatListener> statListeners = new ArrayList<StatListener>();
    private static boolean clientRunning;
    private static boolean clientSuspended;
    private static String programStatus;
    private static long clientStartTime;
    private static int filesSent;
    private static int filesRcvd;
    private static long bytesSent;
    private static long bytesRcvd;
    private static int cacheCount;
    private static long cacheSize;
    private static int[] bytesSentHistory;
    private static int openConnections;
    private static int lastServerContact;

    public static void trackBytesSentHistory() {
        bytesSentHistory = new int[361];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStatListener(StatListener statListener) {
        List<StatListener> list = statListeners;
        synchronized (list) {
            if (!statListeners.contains(statListener)) {
                statListeners.add(statListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStatListener(StatListener statListener) {
        List<StatListener> list = statListeners;
        synchronized (list) {
            statListeners.remove(statListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void statChanged(String string) {
        HentaiAtHomeClient hentaiAtHomeClient = Settings.getActiveClient();
        boolean bl = false;
        if (hentaiAtHomeClient == null) {
            bl = true;
        } else if (!hentaiAtHomeClient.isShuttingDown()) {
            bl = true;
        }
        if (bl) {
            List<StatListener> list = statListeners;
            synchronized (list) {
                for (StatListener statListener : statListeners) {
                    statListener.statChanged(string);
                }
            }
        }
    }

    public static void setProgramStatus(String string) {
        programStatus = string;
        Stats.statChanged("programStatus");
    }

    public static void resetStats() {
        clientRunning = false;
        programStatus = "Stopped";
        clientStartTime = 0L;
        lastServerContact = 0;
        filesSent = 0;
        filesRcvd = 0;
        bytesSent = 0L;
        bytesRcvd = 0L;
        cacheCount = 0;
        cacheSize = 0L;
        Stats.resetBytesSentHistory();
        Stats.statChanged("reset");
    }

    public static void shiftBytesSentHistory() {
        if (bytesSentHistory == null) {
            return;
        }
        for (int i = 360; i > 0; --i) {
            Stats.bytesSentHistory[i] = bytesSentHistory[i - 1];
        }
        Stats.bytesSentHistory[0] = 0;
        Stats.statChanged("bytesSentHistory");
    }

    public static void resetBytesSentHistory() {
        if (bytesSentHistory == null) {
            return;
        }
        Arrays.fill(bytesSentHistory, 0);
        Stats.statChanged("bytesSentHistory");
    }

    public static void programStarted() {
        clientStartTime = System.currentTimeMillis();
        clientRunning = true;
        Stats.setProgramStatus("Running");
        Stats.statChanged("clientRunning");
    }

    public static void programSuspended() {
        clientSuspended = true;
        Stats.setProgramStatus("Suspended");
        Stats.statChanged("clientSuspended");
    }

    public static void programResumed() {
        clientSuspended = false;
        Stats.setProgramStatus("Running");
        Stats.statChanged("clientSuspended");
    }

    public static void serverContact() {
        lastServerContact = (int)(System.currentTimeMillis() / 1000L);
        Stats.statChanged("lastServerContact");
    }

    public static void fileSent() {
        ++filesSent;
        Stats.statChanged("fileSent");
    }

    public static void fileRcvd() {
        ++filesRcvd;
        Stats.statChanged("fileRcvd");
    }

    public static void bytesSent(int n) {
        if (bytesSentHistory == null) {
            return;
        }
        if (clientRunning) {
            bytesSent += (long)n;
            bytesSentHistory[0] = bytesSentHistory[0] + n;
        }
        Stats.statChanged("bytesSent");
    }

    public static void bytesRcvd(int n) {
        if (clientRunning) {
            bytesRcvd += (long)n;
            Stats.statChanged("bytesRcvd");
        }
    }

    public static void setCacheCount(int n) {
        cacheCount = n;
        Stats.statChanged("cacheCount");
    }

    public static void setCacheSize(long l) {
        cacheSize = l;
        Stats.statChanged("cacheSize");
    }

    public static void setOpenConnections(int n) {
        openConnections = n;
        Stats.statChanged("openConnections");
    }

    public static boolean isClientRunning() {
        return clientRunning;
    }

    public static boolean isClientSuspended() {
        return clientSuspended;
    }

    public static String getProgramStatus() {
        return programStatus;
    }

    public static int getUptime() {
        return (int)Stats.getUptimeDouble();
    }

    public static double getUptimeDouble() {
        if (clientRunning) {
            return (double)(System.currentTimeMillis() - clientStartTime) / 1000.0;
        }
        return 0.0;
    }

    public static long getFilesSent() {
        return filesSent;
    }

    public static long getFilesRcvd() {
        return filesRcvd;
    }

    public static long getBytesSent() {
        return bytesSent;
    }

    public static int[] getBytesSentHistory() {
        return bytesSentHistory;
    }

    public static long getBytesRcvd() {
        return bytesRcvd;
    }

    public static int getBytesSentPerSec() {
        double d = Stats.getUptimeDouble();
        return d > 0.0 ? (int)((double)bytesSent / d) : 0;
    }

    public static int getBytesRcvdPerSec() {
        double d = Stats.getUptimeDouble();
        return d > 0.0 ? (int)((double)bytesRcvd / d) : 0;
    }

    public static int getCacheCount() {
        return cacheCount;
    }

    public static long getCacheSize() {
        return cacheSize;
    }

    public static long getCacheFree() {
        return Settings.getDiskLimitBytes() - cacheSize;
    }

    public static float getCacheFill() {
        return Settings.getDiskLimitBytes() != 0L ? (float)cacheSize / (float)Settings.getDiskLimitBytes() : 0.0f;
    }

    public static int getOpenConnections() {
        return openConnections;
    }

    public static int getLastServerContact() {
        return lastServerContact;
    }

    static {
        Stats.resetStats();
    }
}

