/*
 * Decompiled with CFR 0.152.
 */
package hath.base;

import hath.base.HentaiAtHomeClient;
import hath.base.Out;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Hashtable;

public class Tools {
    public static File checkAndCreateDir(File file) throws IOException {
        if (file.isFile()) {
            file.delete();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Could not create directory " + file + "; check permissions and I/O errors.");
        }
        return file;
    }

    public static String getStringFileContents(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        return new String(cArray);
    }

    public static void putStringFileContents(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static void putStringFileContents(File file, String string, String string2) throws IOException {
        int n = string.length();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
        bufferedWriter.write(string, 0, n);
        bufferedWriter.close();
    }

    public static File[] listSortedFiles(File file) {
        Object[] objectArray = file.listFiles();
        if (objectArray != null) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public static Hashtable<String, String> parseAdditional(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            for (String string2 : stringArray = string.trim().split(";")) {
                if (string2.length() <= 2) continue;
                String[] stringArray2 = string2.trim().split("=", 2);
                if (stringArray2.length == 2) {
                    hashtable.put(stringArray2[0].trim(), stringArray2[1].trim());
                    continue;
                }
                Out.warning("Invalid kvPair: " + string2);
            }
        }
        return hashtable;
    }

    public static String getSHA1String(String string) {
        String string2 = null;
        try {
            string2 = Tools.binaryToHex(MessageDigest.getInstance("SHA-1").digest(string.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HentaiAtHomeClient.dieWithError(noSuchAlgorithmException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA1String(File file) {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        String string = null;
        try {
            abstractInterruptibleChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)Math.min(65536L, file.length()));
            while (((FileChannel)abstractInterruptibleChannel).read(byteBuffer) != -1) {
                byteBuffer.flip();
                messageDigest.update(byteBuffer);
                byteBuffer.clear();
            }
            string = Tools.binaryToHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HentaiAtHomeClient.dieWithError(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            Out.warning("Failed to calculate SHA-1 hash of file " + file + ": " + iOException.getMessage());
        }
        finally {
            try {
                abstractInterruptibleChannel.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static String binaryToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString().toLowerCase();
    }
}

