/*
 * Decompiled with CFR 0.152.
 */
package hath.gui;

import hath.base.Settings;
import hath.base.StatListener;
import hath.base.Stats;
import hath.gui.HentaiAtHomeClientGUI;
import hath.gui.StorageUnit;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HHControlPane
extends JPanel {
    private HentaiAtHomeClientGUI clientGUI;
    private StatPane statPane;
    private GraphPane graphPane;
    private String[] argStrings = new String[]{"Client Status:", "Uptime:", "Last Check-In:", "Total Files Sent:", "Total Files Rcvd:", "Total Bytes Sent:", "Total Bytes Rcvd:", "Avg Bytes Sent:", "Avg Bytes Rcvd:", "Cache Filecount:", "Used Cache Size:", "Cache Utilization:", "Free Cache Size:", "Static Ranges:", "Connections:"};
    private int[] argLengths = null;
    private DecimalFormat df;

    public HHControlPane(HentaiAtHomeClientGUI hentaiAtHomeClientGUI) {
        this.clientGUI = hentaiAtHomeClientGUI;
        this.df = new DecimalFormat("0.00");
        this.setPreferredSize(new Dimension(1000, 220));
        this.setLayout(new BorderLayout());
        this.statPane = new StatPane();
        this.graphPane = new GraphPane();
        this.add((Component)this.statPane, "Before");
        this.add((Component)this.graphPane, "Center");
    }

    public void updateData() {
        this.statPane.updateStats();
    }

    static /* synthetic */ int[] access$102(HHControlPane hHControlPane, int[] nArray) {
        hHControlPane.argLengths = nArray;
        return nArray;
    }

    private class GraphPane
    extends JPanel
    implements StatListener {
        private short[] graphHeights;
        private long lastGraphRefresh = 0L;
        private int peakSpeedKBps = 0;
        private BasicStroke graphStroke = new BasicStroke(2.0f, 2, 0);
        private BasicStroke otherStroke = new BasicStroke(1.0f);
        private Font myFont;

        public GraphPane() {
            this.setMinimumSize(new Dimension(650, 220));
            Stats.addStatListener(this);
            this.repaint();
        }

        @Override
        public void statChanged(String string) {
            if (string.equals("bytesSentHistory")) {
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            if (!HHControlPane.this.clientGUI.isShowing()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
            if (this.myFont == null) {
                this.myFont = new Font("Sans-serif", 0, 10);
            }
            graphics2D.setFont(this.myFont);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n5 = 0;
            int n6 = this.getWidth() - 2;
            double d = (double)n6 / 354.0;
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(n5, 2, n6 + 1, 215);
            graphics2D.setColor(Color.GRAY);
            int n7 = n6 / 6;
            int n8 = 215;
            int n9 = 2;
            for (n4 = 1; n4 <= 5; ++n4) {
                n3 = n5 + n7 * n4;
                graphics2D.drawLine(n3, n9, n3, n8);
            }
            n4 = n5 + 1;
            n3 = n8 - n9;
            if (this.graphHeights == null || this.lastGraphRefresh < System.currentTimeMillis() - 10000L) {
                if (this.graphHeights == null) {
                    this.graphHeights = new short[354];
                }
                Arrays.fill(this.graphHeights, (short)0);
                int[] nArray = Stats.getBytesSentHistory();
                double d2 = 6000000.0;
                if (nArray != null) {
                    double d3;
                    double d4 = d3 = (double)(nArray[360] + nArray[359] + nArray[358] + nArray[357] + nArray[356] + nArray[355]);
                    for (n2 = 360; n2 > 6; --n2) {
                        d4 = d4 + (double)nArray[n2 - 6] - (double)nArray[n2];
                        d2 = Math.max(d2, d4);
                    }
                    d2 = 1200000.0 * Math.ceil(d2 / 1200000.0);
                    d4 = d3;
                    n2 = 0;
                    for (int i = 360; i > 6; --i) {
                        d4 = d4 + (double)nArray[i - 6] - (double)nArray[i];
                        this.graphHeights[n2++] = (short)((double)n3 * d4 / d2);
                    }
                }
                this.peakSpeedKBps = (int)(d2 / 60000.0);
            }
            graphics2D.setColor(Color.GREEN);
            graphics2D.setStroke(this.graphStroke);
            int n10 = 0;
            int n11 = (int)Math.round((double)n4 + d * 0.0);
            int n12 = 0;
            int n13 = Math.round(n8 - this.graphHeights[0]);
            for (n = 1; n < 354; ++n) {
                n10 = n11;
                n11 = (int)Math.round((double)n4 + d * (double)n);
                n12 = n13;
                n13 = Math.round(n8 - this.graphHeights[n]);
                graphics2D.drawLine(n10, n12, n11, n13);
            }
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.setStroke(this.otherStroke);
            n = n9;
            int n14 = (int)((double)n9 + (double)n3 * 0.25);
            int n15 = (int)((double)n9 + (double)n3 * 0.5);
            n2 = (int)((double)n9 + (double)n3 * 0.75);
            graphics2D.drawString(this.peakSpeedKBps + " KB/s", 7, n + 12);
            graphics2D.drawLine(n5, n, n6 + 3, n);
            graphics2D.drawString((int)((double)this.peakSpeedKBps * 0.75) + " KB/s", 7, n14 + 12);
            graphics2D.drawLine(n5, n14, n6 + 3, n14);
            graphics2D.drawString((int)((double)this.peakSpeedKBps * 0.5) + " KB/s", 7, n15 + 12);
            graphics2D.drawLine(n5, n15, n6 + 3, n15);
            graphics2D.drawString((int)((double)this.peakSpeedKBps * 0.25) + " KB/s", 7, n2 + 12);
            graphics2D.drawLine(n5, n2, n6 + 3, n2);
        }
    }

    private class StatPane
    extends JPanel
    implements StatListener {
        private Font myFont;

        public StatPane() {
            this.setPreferredSize(new Dimension(350, 220));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Program Stats"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.getBorder()));
            Stats.addStatListener(this);
            this.repaint();
        }

        @Override
        public void statChanged(String string) {
        }

        public void updateStats() {
            this.repaint(50L);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            if (!HHControlPane.this.clientGUI.isShowing()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
            if (this.myFont == null) {
                this.myFont = new Font("Sans-serif", 0, 10);
            }
            graphics2D.setFont(this.myFont);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.BLACK);
            int n2 = 10;
            int n3 = 30;
            int n4 = 24;
            int n5 = 95;
            int n6 = 70;
            int n7 = n2 + n5;
            int n8 = n7 + n6 + n5;
            if (HHControlPane.this.argLengths == null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                HHControlPane.access$102(HHControlPane.this, new int[HHControlPane.this.argStrings.length]);
                n = 0;
                for (String string : HHControlPane.this.argStrings) {
                    ((HHControlPane)HHControlPane.this).argLengths[n++] = fontMetrics.stringWidth(string);
                }
            }
            int n9 = 0;
            n = 0;
            for (String string : HHControlPane.this.argStrings) {
                graphics2D.drawString(string, (n9 % 2 == 0 ? n7 : n8) - HHControlPane.this.argLengths[n++] - 7, n3 + n4 * (n9 / 2));
                n9 += n9 == 0 ? 2 : 1;
            }
            int n10 = Stats.getLastServerContact();
            long l = Stats.getBytesSent();
            long l2 = Stats.getBytesRcvd();
            int n11 = Stats.getBytesSentPerSec();
            int n12 = Stats.getBytesRcvdPerSec();
            long l3 = Stats.getCacheSize();
            long l4 = Stats.getCacheFree();
            graphics2D.drawString(Stats.getProgramStatus(), n7, n3 + n4 * 0);
            graphics2D.drawString(Stats.getUptime() / 3600 + " hr " + Stats.getUptime() % 3600 / 60 + " min", n7, n3 + n4 * 1);
            graphics2D.drawString(n10 == 0 ? "Never" : (int)(System.currentTimeMillis() / 1000L) - n10 + " sec ago", n8, n3 + n4 * 1);
            graphics2D.drawString(Stats.getFilesSent() + "", n7, n3 + n4 * 2);
            graphics2D.drawString(Stats.getFilesRcvd() + "", n8, n3 + n4 * 2);
            graphics2D.drawString(StorageUnit.of(l).format(l), n7, n3 + n4 * 3);
            graphics2D.drawString(StorageUnit.of(l2).format(l2), n8, n3 + n4 * 3);
            graphics2D.drawString(StorageUnit.of(n11).format(n11) + "/s", n7, n3 + n4 * 4);
            graphics2D.drawString(StorageUnit.of(n12).format(n12) + "/s", n8, n3 + n4 * 4);
            graphics2D.drawString(Stats.getCacheCount() + "", n7, n3 + n4 * 5);
            graphics2D.drawString(StorageUnit.of(l3).format(l3), n8, n3 + n4 * 5);
            graphics2D.drawString(HHControlPane.this.df.format(Stats.getCacheFill() * 100.0f) + "%", n7, n3 + n4 * 6);
            graphics2D.drawString(StorageUnit.of(l4).format(l4), n8, n3 + n4 * 6);
            graphics2D.drawString(Settings.getStaticRangeCount() + "", n7, n3 + n4 * 7);
            graphics2D.drawString(Stats.getOpenConnections() + " / " + Settings.getMaxConnections(), n8, n3 + n4 * 7);
        }
    }
}

