/*
 * Decompiled with CFR 0.152.
 */
package hath.gui;

import hath.base.Out;
import hath.base.OutListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HHLogPane
extends JPanel
implements OutListener,
ComponentListener {
    private final int LOG_LINE_COUNT = 100;
    private JTextArea textArea;
    private String[] loglines;
    private StringBuilder stringBuilder;
    private int logpointer = 0;
    private int logLinesSinceRebuild = 0;
    private long lastLogDisplayRebuild = 0L;
    private Object logSyncer = new Object();
    private int stringCutoff = 142;
    private int displayLineCount = 18;
    private boolean windowResized = false;

    public HHLogPane() {
        this.loglines = new String[100];
        this.stringBuilder = new StringBuilder(3000);
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea("");
        this.textArea.setFont(new Font("Courier", 0, 11));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        this.addText("Hentai@Home GUI 1.6.1 initializing...");
        this.addText("The client will automatically start up momentarily...");
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 21, 31);
        jScrollPane.setPreferredSize(new Dimension(1000, 300));
        this.add((Component)jScrollPane, "Center");
        Out.addOutListener(this);
        this.addComponentListener(this);
    }

    @Override
    public void outputWritten(String string) {
        this.addText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addText(String string) {
        Object object = this.logSyncer;
        synchronized (object) {
            if (++this.logpointer >= 100) {
                this.logpointer = 0;
            }
            this.loglines[this.logpointer] = string.length() > this.stringCutoff ? string.substring(0, this.stringCutoff) : string;
            ++this.logLinesSinceRebuild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRebuildLogDisplay() {
        long l = System.currentTimeMillis();
        if (this.windowResized) {
            this.windowResized = false;
            this.stringCutoff = Math.max(this.stringCutoff, this.getWidth() / 7);
            this.displayLineCount = Math.max(1, Math.min(100, this.getHeight() / 16));
        } else if (this.logLinesSinceRebuild < 1 || l - this.lastLogDisplayRebuild < 500L) {
            return;
        }
        this.lastLogDisplayRebuild = l;
        this.logLinesSinceRebuild = 0;
        this.stringBuilder.setLength(0);
        int n = 100 - this.displayLineCount;
        Object object = this.logSyncer;
        synchronized (object) {
            while (++n <= 100) {
                int n2 = this.logpointer + n;
                n2 = n2 >= 100 ? n2 - 100 : n2;
                if (this.loglines[n2] == null) continue;
                this.stringBuilder.append(this.loglines[n2]);
                this.stringBuilder.append("\n");
            }
        }
        this.textArea.setText(this.stringBuilder.toString());
        this.textArea.setCaretPosition(this.stringBuilder.length());
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.windowResized = true;
        this.checkRebuildLogDisplay();
    }
}

