/*
 * Decompiled with CFR 0.152.
 */
package hath.gui;

import java.text.NumberFormat;

public enum StorageUnit {
    BYTE("B", 1L),
    KILOBYTE("KB", 1024L),
    MEGABYTE("MB", 0x100000L),
    GIGABYTE("GB", 0x40000000L),
    TERABYTE("TB", 0x10000000000L),
    PETABYTE("PB", 0x4000000000000L),
    EXABYTE("EB", 0x1000000000000000L);

    public static final StorageUnit BASE;
    private final String symbol;
    private final long divider;
    private static NumberFormat nf;

    private StorageUnit(String string2, long l) {
        this.symbol = string2;
        this.divider = l;
    }

    public static StorageUnit of(long l) {
        long l2;
        long l3 = l2 = l > 0L ? -l : l;
        if (l2 > -1024L) {
            return BYTE;
        }
        if (l2 > -1048576L) {
            return KILOBYTE;
        }
        if (l2 > -1073741824L) {
            return MEGABYTE;
        }
        if (l2 > -1099511627776L) {
            return GIGABYTE;
        }
        if (l2 > -1125899906842624L) {
            return TERABYTE;
        }
        if (l2 > -1152921504606846976L) {
            return PETABYTE;
        }
        return EXABYTE;
    }

    public String format(long l) {
        return nf.format((double)l / (double)this.divider) + " " + this.symbol;
    }

    static {
        BASE = BYTE;
        nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
    }
}

